/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.features;

import com.google.common.util.concurrent.ListenableFuture;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.collect.PagedIterable;
import org.jclouds.openstack.keystone.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.keystone.v2_0.functions.ReturnEmptyPaginatedCollectionOnNotFoundOr404;
import org.jclouds.openstack.nova.v2_0.domain.Flavor;
import org.jclouds.openstack.nova.v2_0.functions.internal.ParseFlavorDetails;
import org.jclouds.openstack.nova.v2_0.functions.internal.ParseFlavors;
import org.jclouds.openstack.v2_0.domain.Resource;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.functions.ReturnEmptyPagedIterableOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;

@RequestFilters(value={AuthenticateRequest.class})
public interface FlavorAsyncApi {
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/flavors")
    @RequestFilters(value={AuthenticateRequest.class})
    @ResponseParser(value=ParseFlavors.class)
    @Transform(value=ParseFlavors.ToPagedIterable.class)
    @ExceptionParser(value=ReturnEmptyPagedIterableOnNotFoundOr404.class)
    public ListenableFuture<? extends PagedIterable<? extends Resource>> list();

    @GET
    @Consumes(value={"application/json"})
    @Path(value="/flavors")
    @RequestFilters(value={AuthenticateRequest.class})
    @ResponseParser(value=ParseFlavors.class)
    @ExceptionParser(value=ReturnEmptyPaginatedCollectionOnNotFoundOr404.class)
    public ListenableFuture<? extends PaginatedCollection<? extends Resource>> list(PaginationOptions var1);

    @GET
    @Consumes(value={"application/json"})
    @Path(value="/flavors/detail")
    @RequestFilters(value={AuthenticateRequest.class})
    @ResponseParser(value=ParseFlavorDetails.class)
    @Transform(value=ParseFlavorDetails.ToPagedIterable.class)
    @ExceptionParser(value=ReturnEmptyPagedIterableOnNotFoundOr404.class)
    public ListenableFuture<? extends PagedIterable<? extends Flavor>> listInDetail();

    @GET
    @Consumes(value={"application/json"})
    @Path(value="/flavors/detail")
    @RequestFilters(value={AuthenticateRequest.class})
    @ResponseParser(value=ParseFlavorDetails.class)
    @ExceptionParser(value=ReturnEmptyPaginatedCollectionOnNotFoundOr404.class)
    public ListenableFuture<? extends PaginatedCollection<? extends Flavor>> listInDetail(PaginationOptions var1);

    @GET
    @SelectJson(value={"flavor"})
    @Consumes(value={"application/json"})
    @Path(value="/flavors/{id}")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<? extends Flavor> get(@PathParam(value="id") String var1);
}

