/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v1_1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Date;

public class Token
implements Comparable<Token> {
    protected String id;
    protected Date expires;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Token.builder().fromToken(this);
    }

    protected Token() {
    }

    public Token(String id, Date expires) {
        this.id = Preconditions.checkNotNull(id, "id");
        this.expires = Preconditions.checkNotNull(expires, "expires");
    }

    public String getId() {
        return this.id;
    }

    public Date getExpires() {
        return this.expires;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Token) {
            Token other = (Token)Token.class.cast(object);
            return Objects.equal(this.id, other.id) && Objects.equal(this.expires, other.expires);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.expires);
    }

    public String toString() {
        return Objects.toStringHelper("").add("id", this.id).add("expires", this.expires).toString();
    }

    @Override
    public int compareTo(Token that) {
        if (that == null) {
            return 1;
        }
        if (this == that) {
            return 0;
        }
        return this.id.compareTo(that.id);
    }

    public static class Builder {
        protected String id;
        protected Date expires;

        public Builder id(String id) {
            this.id = Preconditions.checkNotNull(id, "id");
            return this;
        }

        public Builder expires(Date expires) {
            this.expires = Preconditions.checkNotNull(expires, "expires");
            return this;
        }

        public Token build() {
            return new Token(this.id, this.expires);
        }

        public Builder fromToken(Token from) {
            return this.id(from.getId()).expires(from.getExpires());
        }
    }
}

