/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v1_1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.Set;
import org.jclouds.openstack.keystone.v1_1.domain.Endpoint;
import org.jclouds.openstack.keystone.v1_1.domain.Token;
import org.jclouds.util.Multimaps2;

public class Auth
implements Comparable<Auth> {
    protected Token token;
    protected Map<String, Set<Endpoint>> serviceCatalog = ImmutableMap.of();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Auth.builder().fromAccess(this);
    }

    protected Auth() {
    }

    public Auth(Token token, Multimap<String, Endpoint> serviceCatalog) {
        this.token = Preconditions.checkNotNull(token, "token");
        this.serviceCatalog = Multimaps2.toOldSchool(ImmutableMultimap.copyOf(Preconditions.checkNotNull(serviceCatalog, "serviceCatalog")));
    }

    public Token getToken() {
        return this.token;
    }

    public Multimap<String, Endpoint> getServiceCatalog() {
        return Multimaps2.fromOldSchool(this.serviceCatalog);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Auth) {
            Auth other = (Auth)Auth.class.cast(object);
            return Objects.equal(this.token, other.token) && Objects.equal(this.serviceCatalog, other.serviceCatalog);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.token, this.serviceCatalog);
    }

    public String toString() {
        return Objects.toStringHelper("").add("token", this.token).add("serviceCatalog", this.serviceCatalog).toString();
    }

    @Override
    public int compareTo(Auth that) {
        if (that == null) {
            return 1;
        }
        if (this == that) {
            return 0;
        }
        return this.token.compareTo(that.token);
    }

    public static class Builder {
        protected Token token;
        protected Multimap<String, Endpoint> serviceCatalog = ImmutableMultimap.of();

        public Builder token(Token token) {
            this.token = Preconditions.checkNotNull(token, "token");
            return this;
        }

        public Builder serviceCatalog(Multimap<String, Endpoint> serviceCatalog) {
            this.serviceCatalog = ImmutableMultimap.copyOf(Preconditions.checkNotNull(serviceCatalog, "serviceCatalog"));
            return this;
        }

        public Auth build() {
            return new Auth(this.token, this.serviceCatalog);
        }

        public Builder fromAccess(Auth from) {
            return this.token(from.getToken()).serviceCatalog(from.getServiceCatalog());
        }
    }
}

