/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;

public class AuthenticationResponse {
    private final String authToken;
    private final Map<String, URI> services;

    public AuthenticationResponse(String authToken, Map<String, URI> services) {
        this.authToken = Preconditions.checkNotNull(authToken, "authToken");
        this.services = ImmutableMap.copyOf(Preconditions.checkNotNull(services, "services"));
    }

    public Map<String, URI> getServices() {
        return this.services;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public int hashCode() {
        return Objects.hashCode(this.authToken, this.services);
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        return Objects.equal(this.toString(), that.toString());
    }

    public String toString() {
        return Objects.toStringHelper(this).add("authToken", this.authToken).add("services", this.services).toString();
    }
}

