/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.options;

import com.google.common.base.Preconditions;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class AddServerOptions
extends BaseHttpRequestOptions {
    public AddServerOptions withDescription(String description) {
        Preconditions.checkArgument(description.length() <= 500, "Description cannot be longer than 500 characters");
        Preconditions.checkState(!this.queryParameters.containsKey("description"), "Can't have duplicate server description");
        this.queryParameters.put("description", description);
        return this;
    }

    public AddServerOptions asSandboxType() {
        Preconditions.checkState(!this.queryParameters.containsKey("isSandbox"), "Can only have one sandbox option per server");
        this.queryParameters.put("isSandbox", "true");
        return this;
    }

    public static class Builder {
        public static AddServerOptions withDescription(String description) {
            AddServerOptions options = new AddServerOptions();
            return options.withDescription(description);
        }

        public static AddServerOptions asSandboxType() {
            AddServerOptions options = new AddServerOptions();
            return options.asSandboxType();
        }
    }
}

