/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import java.security.SecureRandom;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.gogrid.GoGridClient;
import org.jclouds.gogrid.compute.suppliers.GoGridHardwareSupplier;
import org.jclouds.gogrid.domain.Ip;
import org.jclouds.gogrid.domain.IpType;
import org.jclouds.gogrid.domain.Option;
import org.jclouds.gogrid.domain.PowerCommand;
import org.jclouds.gogrid.domain.Server;
import org.jclouds.gogrid.domain.ServerImage;
import org.jclouds.gogrid.options.AddServerOptions;
import org.jclouds.gogrid.options.GetImageListOptions;
import org.jclouds.gogrid.options.GetIpListOptions;
import org.jclouds.gogrid.options.GetServerListOptions;
import org.jclouds.gogrid.predicates.ServerLatestJobCompleted;
import org.jclouds.logging.Logger;
import org.jclouds.predicates.RetryablePredicate;

@Singleton
public class GoGridComputeServiceAdapter
implements ComputeServiceAdapter<Server, Hardware, ServerImage, Option> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final GoGridClient client;
    private final Function<Hardware, String> sizeToRam;
    private final RetryablePredicate<Server> serverLatestJobCompleted;
    private final RetryablePredicate<Server> serverLatestJobCompletedShort;

    @Inject
    protected GoGridComputeServiceAdapter(GoGridClient client, Function<Hardware, String> sizeToRam, ComputeServiceConstants.Timeouts timeouts) {
        this.client = Preconditions.checkNotNull(client, "client");
        this.sizeToRam = Preconditions.checkNotNull(sizeToRam, "sizeToRam");
        this.serverLatestJobCompleted = new RetryablePredicate<Server>(new ServerLatestJobCompleted(client.getJobServices()), timeouts.nodeRunning * 9L / 10L);
        this.serverLatestJobCompletedShort = new RetryablePredicate<Server>(new ServerLatestJobCompleted(client.getJobServices()), timeouts.nodeRunning * 1L / 10L);
    }

    @Override
    public ComputeServiceAdapter.NodeAndInitialCredentials<Server> createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        Server addedServer = null;
        boolean notStarted = true;
        int numOfRetries = 20;
        GetIpListOptions unassignedIps = new GetIpListOptions().onlyUnassigned().inDatacenter(template.getLocation().getId()).onlyWithType(IpType.PUBLIC);
        while (notStarted) {
            Set<Ip> availableIps = this.client.getIpServices().getIpList(unassignedIps);
            if (availableIps.isEmpty()) {
                throw new RuntimeException("No IPs available on this identity.");
            }
            int ipIndex = new SecureRandom().nextInt(availableIps.size());
            Ip availableIp = Iterables.get(availableIps, ipIndex);
            try {
                addedServer = this.addServer(name, template, availableIp);
                notStarted = false;
            }
            catch (Exception e) {
                if (--numOfRetries == 0) {
                    Throwables.propagate(e);
                }
                notStarted = true;
            }
        }
        if (template.getOptions().shouldBlockUntilRunning()) {
            this.serverLatestJobCompleted.apply(addedServer);
            this.client.getServerServices().power(addedServer.getName(), PowerCommand.START);
            this.serverLatestJobCompletedShort.apply(addedServer);
            addedServer = Iterables.getOnlyElement(this.client.getServerServices().getServersByName(addedServer.getName()));
        }
        LoginCredentials credentials = LoginCredentials.fromCredentials(this.client.getServerServices().getServerCredentialsList().get(addedServer.getName()));
        return new ComputeServiceAdapter.NodeAndInitialCredentials<Server>(addedServer, addedServer.getId() + "", credentials);
    }

    private Server addServer(String name, Template template, Ip availableIp) {
        Server addedServer = this.client.getServerServices().addServer(name, Preconditions.checkNotNull(template.getImage().getProviderId()), this.sizeToRam.apply(template.getHardware()), availableIp.getIp(), new AddServerOptions[0]);
        return addedServer;
    }

    @Override
    public Iterable<Hardware> listHardwareProfiles() {
        return GoGridHardwareSupplier.H_ALL;
    }

    @Override
    public Iterable<ServerImage> listImages() {
        return this.client.getImageServices().getImageList(new GetImageListOptions[0]);
    }

    @Override
    public Iterable<Server> listNodes() {
        return this.client.getServerServices().getServerList(new GetServerListOptions[0]);
    }

    @Override
    public Iterable<Option> listLocations() {
        return this.client.getServerServices().getDatacenters();
    }

    @Override
    public Server getNode(String id) {
        return Iterables.getOnlyElement(this.client.getServerServices().getServersById(Long.valueOf(Preconditions.checkNotNull(id, "id"))), null);
    }

    @Override
    public ServerImage getImage(String id) {
        return Iterables.getOnlyElement(this.client.getImageServices().getImagesById(Long.valueOf(Preconditions.checkNotNull(id, "id"))), null);
    }

    @Override
    public void destroyNode(String id) {
        this.client.getServerServices().deleteById(Long.valueOf(id));
    }

    @Override
    public void rebootNode(String id) {
        this.executeCommandOnServer(PowerCommand.RESTART, id);
        Server server = Iterables.getOnlyElement(this.client.getServerServices().getServersById(Long.valueOf(id)));
        this.client.getServerServices().power(server.getName(), PowerCommand.START);
        this.serverLatestJobCompletedShort.apply(server);
    }

    private boolean executeCommandOnServer(PowerCommand command, String id) {
        Server server = Iterables.getOnlyElement(this.client.getServerServices().getServersById(Long.valueOf(id)));
        this.client.getServerServices().power(server.getName(), command);
        return this.serverLatestJobCompleted.apply(server);
    }

    @Override
    public void resumeNode(String id) {
        this.executeCommandOnServer(PowerCommand.START, id);
    }

    @Override
    public void suspendNode(String id) {
        this.executeCommandOnServer(PowerCommand.STOP, id);
    }
}

