/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.domain;

import com.google.common.base.Preconditions;
import java.net.URI;
import org.jclouds.javax.annotation.Nullable;

public class Image {
    private final URI href;
    private final String id;
    private final String ownerId;
    @Nullable
    private final String name;
    @Nullable
    private final String description;
    private final String architecture;

    public Image(URI href, String id, String ownerId, @Nullable String name, String description, String architecture) {
        this.href = Preconditions.checkNotNull(href, "href");
        this.id = Preconditions.checkNotNull(id, "id");
        this.ownerId = Preconditions.checkNotNull(ownerId, "ownerId");
        this.name = name;
        this.description = description;
        this.architecture = Preconditions.checkNotNull(architecture, "architecture");
    }

    public URI getHref() {
        return this.href;
    }

    public String getId() {
        return this.id;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.architecture == null ? 0 : this.architecture.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.href == null ? 0 : this.href.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.ownerId == null ? 0 : this.ownerId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Image other = (Image)obj;
        if (this.architecture == null ? other.architecture != null : !this.architecture.equals(other.architecture)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.href == null ? other.href != null : !this.href.equals(other.href)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.ownerId == null ? other.ownerId != null : !this.ownerId.equals(other.ownerId));
    }

    public String toString() {
        return "[href=" + this.href + ", id=" + this.id + ", ownerId=" + this.ownerId + ", name=" + this.name + ", description=" + this.description + ", architecture=" + this.architecture + "]";
    }
}

