/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Provides;
import java.util.Date;
import java.util.Set;
import javax.inject.Named;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.cloudwatch.domain.Datapoint;
import org.jclouds.cloudwatch.domain.Statistics;
import org.jclouds.cloudwatch.features.MetricAsyncApi;
import org.jclouds.cloudwatch.functions.ISO8601Format;
import org.jclouds.cloudwatch.options.GetMetricStatisticsOptions;
import org.jclouds.cloudwatch.xml.GetMetricStatisticsResponseHandler;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.Region;
import org.jclouds.location.functions.RegionToEndpointOrProviderIfNull;
import org.jclouds.rest.annotations.Delegate;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;

@RequestFilters(value={FormSigner.class})
@VirtualHost
public interface CloudWatchAsyncApi {
    @Provides
    @Region
    public Set<String> getConfiguredRegions();

    @Named(value="cloudwatch:GetMetricStatistics")
    @Deprecated
    @POST
    @Path(value="/")
    @XMLResponseParser(value=GetMetricStatisticsResponseHandler.class)
    @FormParams(keys={"Action"}, values={"GetMetricStatistics"})
    public ListenableFuture<? extends Set<Datapoint>> getMetricStatisticsInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="MetricName") String var2, @FormParam(value="Namespace") String var3, @FormParam(value="StartTime") @ParamParser(value=ISO8601Format.class) Date var4, @FormParam(value="EndTime") @ParamParser(value=ISO8601Format.class) Date var5, @FormParam(value="Period") int var6, @FormParam(value="Statistics.member.1") Statistics var7, GetMetricStatisticsOptions ... var8);

    @Delegate
    public MetricAsyncApi getMetricApi();

    @Delegate
    public MetricAsyncApi getMetricApiForRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1);
}

