/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.suppliers;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.util.NoSuchElementException;
import javax.annotation.Resource;
import javax.inject.Inject;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.domain.User;
import org.jclouds.cloudstack.options.ListAccountsOptions;
import org.jclouds.cloudstack.predicates.UserPredicates;
import org.jclouds.domain.Credentials;
import org.jclouds.location.Provider;
import org.jclouds.logging.Logger;

public class GetCurrentUser
implements Supplier<User> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final CloudStackClient client;
    private final Supplier<Credentials> creds;

    @Inject
    public GetCurrentUser(CloudStackClient client, @Provider Supplier<Credentials> creds) {
        this.client = Preconditions.checkNotNull(client, "client");
        this.creds = Preconditions.checkNotNull(creds, "creds");
    }

    @Override
    public User get() {
        Iterable users = Iterables.concat(this.client.getAccountClient().listAccounts(new ListAccountsOptions[0]));
        Predicate<User> apiKeyMatches = UserPredicates.apiKeyEquals(this.creds.get().identity);
        User currentUser = null;
        try {
            currentUser = Iterables.find(users, apiKeyMatches);
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException(String.format("none of the following users match %s: %s", apiKeyMatches, users));
        }
        return currentUser;
    }
}

