/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;

public class IPForwardingRule
implements Comparable<IPForwardingRule> {
    private final String id;
    private final String IPAddress;
    private final String IPAddressId;
    private final int startPort;
    private final String protocol;
    private final int endPort;
    private final String state;
    private final String virtualMachineDisplayName;
    private final String virtualMachineId;
    private final String virtualMachineName;
    private final int publicPort;
    private final Set<String> CIDRs;
    private final int privateEndPort;
    private final int publicEndPort;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromIPForwardingRule(this);
    }

    @ConstructorProperties(value={"id", "ipaddress", "ipaddressid", "startport", "protocol", "endport", "state", "virtualmachinedisplayname", "virtualmachineid", "virtualmachinename", "publicport", "cidrlist", "privateendport", "publicendport"})
    protected IPForwardingRule(String id, String IPAddress2, String IPAddressId, int startPort, @Nullable String protocol, int endPort, @Nullable String state, @Nullable String virtualMachineDisplayName, @Nullable String virtualMachineId, @Nullable String virtualMachineName, int publicPort, @Nullable Set<String> CIDRs, int privateEndPort, int publicEndPort) {
        this.id = Preconditions.checkNotNull(id, "id");
        this.IPAddress = IPAddress2;
        this.IPAddressId = IPAddressId;
        this.startPort = startPort;
        this.protocol = protocol;
        this.endPort = endPort;
        this.state = state;
        this.virtualMachineDisplayName = virtualMachineDisplayName;
        this.virtualMachineId = virtualMachineId;
        this.virtualMachineName = virtualMachineName;
        this.publicPort = publicPort;
        this.CIDRs = CIDRs == null ? ImmutableSet.of() : ImmutableSet.copyOf(CIDRs);
        this.privateEndPort = privateEndPort;
        this.publicEndPort = publicEndPort;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getIPAddress() {
        return this.IPAddress;
    }

    @Nullable
    public String getIPAddressId() {
        return this.IPAddressId;
    }

    public int getStartPort() {
        return this.startPort;
    }

    @Nullable
    public String getProtocol() {
        return this.protocol;
    }

    public int getEndPort() {
        return this.endPort;
    }

    @Nullable
    public String getState() {
        return this.state;
    }

    @Nullable
    public String getVirtualMachineDisplayName() {
        return this.virtualMachineDisplayName;
    }

    @Nullable
    public String getVirtualMachineId() {
        return this.virtualMachineId;
    }

    @Nullable
    public String getVirtualMachineName() {
        return this.virtualMachineName;
    }

    public int getPublicPort() {
        return this.publicPort;
    }

    public Set<String> getCIDRs() {
        return this.CIDRs;
    }

    public int getPrivateEndPort() {
        return this.privateEndPort;
    }

    public int getPublicEndPort() {
        return this.publicEndPort;
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.IPAddress, this.IPAddressId, this.startPort, this.protocol, this.endPort, this.state, this.virtualMachineDisplayName, this.virtualMachineId, this.virtualMachineName, this.publicPort, this.CIDRs, this.privateEndPort, this.publicEndPort);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IPForwardingRule that = (IPForwardingRule)IPForwardingRule.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal(this.IPAddress, that.IPAddress) && Objects.equal(this.IPAddressId, that.IPAddressId) && Objects.equal(this.startPort, that.startPort) && Objects.equal(this.protocol, that.protocol) && Objects.equal(this.endPort, that.endPort) && Objects.equal(this.state, that.state) && Objects.equal(this.virtualMachineDisplayName, that.virtualMachineDisplayName) && Objects.equal(this.virtualMachineId, that.virtualMachineId) && Objects.equal(this.virtualMachineName, that.virtualMachineName) && Objects.equal(this.publicPort, that.publicPort) && Objects.equal(this.CIDRs, that.CIDRs) && Objects.equal(this.privateEndPort, that.privateEndPort) && Objects.equal(this.publicEndPort, that.publicEndPort);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).add("id", this.id).add("IPAddress", this.IPAddress).add("IPAddressId", this.IPAddressId).add("startPort", this.startPort).add("protocol", this.protocol).add("endPort", this.endPort).add("state", this.state).add("virtualMachineDisplayName", this.virtualMachineDisplayName).add("virtualMachineId", this.virtualMachineId).add("virtualMachineName", this.virtualMachineName).add("publicPort", this.publicPort).add("CIDRs", this.CIDRs).add("privateEndPort", this.privateEndPort).add("publicEndPort", this.publicEndPort);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(IPForwardingRule o) {
        return this.id.compareTo(o.getId());
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String IPAddress;
        protected String IPAddressId;
        protected int startPort;
        protected String protocol;
        protected int endPort;
        protected String state;
        protected String virtualMachineDisplayName;
        protected String virtualMachineId;
        protected String virtualMachineName;
        protected int publicPort;
        protected Set<String> CIDRs = ImmutableSet.of();
        protected int privateEndPort;
        protected int publicEndPort;

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T IPAddress(String IPAddress2) {
            this.IPAddress = IPAddress2;
            return this.self();
        }

        public T IPAddressId(String IPAddressId) {
            this.IPAddressId = IPAddressId;
            return this.self();
        }

        public T startPort(int startPort) {
            this.startPort = startPort;
            return this.self();
        }

        public T protocol(String protocol) {
            this.protocol = protocol;
            return this.self();
        }

        public T endPort(int endPort) {
            this.endPort = endPort;
            return this.self();
        }

        public T state(String state) {
            this.state = state;
            return this.self();
        }

        public T virtualMachineDisplayName(String virtualMachineDisplayName) {
            this.virtualMachineDisplayName = virtualMachineDisplayName;
            return this.self();
        }

        public T virtualMachineId(String virtualMachineId) {
            this.virtualMachineId = virtualMachineId;
            return this.self();
        }

        public T virtualMachineName(String virtualMachineName) {
            this.virtualMachineName = virtualMachineName;
            return this.self();
        }

        public T publicPort(int publicPort) {
            this.publicPort = publicPort;
            return this.self();
        }

        public T CIDRs(Set<String> CIDRs) {
            this.CIDRs = ImmutableSet.copyOf((Collection)Preconditions.checkNotNull(CIDRs, "CIDRs"));
            return this.self();
        }

        public T CIDRs(String ... in) {
            return this.CIDRs(ImmutableSet.copyOf(in));
        }

        public T privateEndPort(int privateEndPort) {
            this.privateEndPort = privateEndPort;
            return this.self();
        }

        public T publicEndPort(int publicEndPort) {
            this.publicEndPort = publicEndPort;
            return this.self();
        }

        public IPForwardingRule build() {
            return new IPForwardingRule(this.id, this.IPAddress, this.IPAddressId, this.startPort, this.protocol, this.endPort, this.state, this.virtualMachineDisplayName, this.virtualMachineId, this.virtualMachineName, this.publicPort, this.CIDRs, this.privateEndPort, this.publicEndPort);
        }

        public T fromIPForwardingRule(IPForwardingRule in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).IPAddress(in.getIPAddress())).IPAddressId(in.getIPAddressId())).startPort(in.getStartPort())).protocol(in.getProtocol())).endPort(in.getEndPort())).state(in.getState())).virtualMachineDisplayName(in.getVirtualMachineDisplayName())).virtualMachineId(in.getVirtualMachineId())).virtualMachineName(in.getVirtualMachineName())).publicPort(in.getPublicPort())).CIDRs(in.getCIDRs())).privateEndPort(in.getPrivateEndPort())).publicEndPort(in.getPublicEndPort());
        }
    }
}

