/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jclouds.cloudstack.domain.User;
import org.jclouds.javax.annotation.Nullable;

public class Account
extends ForwardingSet<User> {
    private final String id;
    private final Type type;
    private final String networkDomain;
    private final String domain;
    private final String domainId;
    private final Long IPsAvailable;
    private final Long IPLimit;
    private final long IPs;
    private final boolean cleanupRequired;
    private final String name;
    private final long receivedBytes;
    private final long sentBytes;
    private final Long snapshotsAvailable;
    private final Long snapshotLimit;
    private final long snapshots;
    private final State state;
    private final Long templatesAvailable;
    private final Long templateLimit;
    private final long templates;
    private final Long VMsAvailable;
    private final Long VMLimit;
    private final long VMsRunning;
    private final long VMsStopped;
    private final long VMs;
    private final Long volumesAvailable;
    private final Long volumeLimit;
    private final long volumes;
    private final Set<User> users;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromAccount(this);
    }

    @ConstructorProperties(value={"id", "accounttype", "networkdomain", "domain", "domainid", "ipavailable", "iplimit", "iptotal", "iscleanuprequired", "name", "receivedbytes", "sentbytes", "snapshotavailable", "snapshotlimit", "snapshottotal", "state", "templateavailable", "templatelimit", "templatetotal", "vmavailable", "vmlimit", "vmrunning", "vmstopped", "vmtotal", "volumeavailable", "volumelimit", "volumetotal", "user"})
    private Account(String id, @Nullable Type type, @Nullable String networkDomain, @Nullable String domain, @Nullable String domainId, @Nullable String IPsAvailable, @Nullable String IPLimit, long IPs, boolean cleanupRequired, @Nullable String name, long receivedBytes, long sentBytes, @Nullable String snapshotsAvailable, @Nullable String snapshotLimit, long snapshots, @Nullable State state, @Nullable String templatesAvailable, @Nullable String templateLimit, long templates, @Nullable String VMsAvailable, @Nullable String VMLimit, long VMsRunning, long VMsStopped, long VMs, @Nullable String volumesAvailable, @Nullable String volumeLimit, long volumes, @Nullable Set<User> users) {
        this(id, type, networkDomain, domain, domainId, Account.toLongNullIfUnlimited(IPsAvailable), Account.toLongNullIfUnlimited(IPLimit), IPs, cleanupRequired, name, receivedBytes, sentBytes, Account.toLongNullIfUnlimited(snapshotsAvailable), Account.toLongNullIfUnlimited(snapshotLimit), snapshots, state, Account.toLongNullIfUnlimited(templatesAvailable), Account.toLongNullIfUnlimited(templateLimit), templates, Account.toLongNullIfUnlimited(VMsAvailable), Account.toLongNullIfUnlimited(VMLimit), VMsRunning, VMsStopped, VMs, Account.toLongNullIfUnlimited(volumesAvailable), Account.toLongNullIfUnlimited(volumeLimit), volumes, users);
    }

    private static Long toLongNullIfUnlimited(String in) {
        return in == null || "Unlimited".equals(in) ? null : Long.valueOf(in);
    }

    protected Account(String id, @Nullable Type type, @Nullable String networkDomain, @Nullable String domain, @Nullable String domainId, @Nullable Long IPsAvailable, @Nullable Long IPLimit, long IPs, boolean cleanupRequired, @Nullable String name, long receivedBytes, long sentBytes, @Nullable Long snapshotsAvailable, @Nullable Long snapshotLimit, long snapshots, @Nullable State state, @Nullable Long templatesAvailable, @Nullable Long templateLimit, long templates, @Nullable Long VMsAvailable, @Nullable Long VMLimit, long VMsRunning, long VMsStopped, long VMs, @Nullable Long volumesAvailable, @Nullable Long volumeLimit, long volumes, @Nullable Set<User> users) {
        this.id = Preconditions.checkNotNull(id, "id");
        this.type = type;
        this.networkDomain = networkDomain;
        this.domain = domain;
        this.domainId = domainId;
        this.IPsAvailable = IPsAvailable;
        this.IPLimit = IPLimit;
        this.IPs = IPs;
        this.cleanupRequired = cleanupRequired;
        this.name = name;
        this.receivedBytes = receivedBytes;
        this.sentBytes = sentBytes;
        this.snapshotsAvailable = snapshotsAvailable;
        this.snapshotLimit = snapshotLimit;
        this.snapshots = snapshots;
        this.state = state;
        this.templatesAvailable = templatesAvailable;
        this.templateLimit = templateLimit;
        this.templates = templates;
        this.VMsAvailable = VMsAvailable;
        this.VMLimit = VMLimit;
        this.VMsRunning = VMsRunning;
        this.VMsStopped = VMsStopped;
        this.VMs = VMs;
        this.volumesAvailable = volumesAvailable;
        this.volumeLimit = volumeLimit;
        this.volumes = volumes;
        this.users = users == null ? ImmutableSet.of() : ImmutableSet.copyOf(users);
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public Type getType() {
        return this.type;
    }

    @Nullable
    public String getNetworkDomain() {
        return this.networkDomain;
    }

    @Nullable
    public String getDomain() {
        return this.domain;
    }

    @Nullable
    public String getDomainId() {
        return this.domainId;
    }

    @Nullable
    public Long getIPsAvailable() {
        return this.IPsAvailable;
    }

    @Nullable
    public Long getIPLimit() {
        return this.IPLimit;
    }

    public long getIPs() {
        return this.IPs;
    }

    public boolean isCleanupRequired() {
        return this.cleanupRequired;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public long getReceivedBytes() {
        return this.receivedBytes;
    }

    public long getSentBytes() {
        return this.sentBytes;
    }

    @Nullable
    public Long getSnapshotsAvailable() {
        return this.snapshotsAvailable;
    }

    @Nullable
    public Long getSnapshotLimit() {
        return this.snapshotLimit;
    }

    public long getSnapshots() {
        return this.snapshots;
    }

    @Nullable
    public State getState() {
        return this.state;
    }

    @Nullable
    public Long getTemplatesAvailable() {
        return this.templatesAvailable;
    }

    @Nullable
    public Long getTemplateLimit() {
        return this.templateLimit;
    }

    public long getTemplates() {
        return this.templates;
    }

    @Nullable
    public Long getVMsAvailable() {
        return this.VMsAvailable;
    }

    @Nullable
    public Long getVMLimit() {
        return this.VMLimit;
    }

    public long getVMsRunning() {
        return this.VMsRunning;
    }

    public long getVMsStopped() {
        return this.VMsStopped;
    }

    public long getVMs() {
        return this.VMs;
    }

    @Nullable
    public Long getVolumesAvailable() {
        return this.volumesAvailable;
    }

    @Nullable
    public Long getVolumeLimit() {
        return this.volumeLimit;
    }

    public long getVolumes() {
        return this.volumes;
    }

    public Set<User> getUsers() {
        return this.users;
    }

    @Override
    protected Set<User> delegate() {
        return this.users;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(new Object[]{this.id, this.type, this.networkDomain, this.domain, this.domainId, this.IPsAvailable, this.IPLimit, this.IPs, this.cleanupRequired, this.name, this.receivedBytes, this.sentBytes, this.snapshotsAvailable, this.snapshotLimit, this.snapshots, this.state, this.templatesAvailable, this.templateLimit, this.templates, this.VMsAvailable, this.VMLimit, this.VMsRunning, this.VMsStopped, this.VMs, this.volumesAvailable, this.volumeLimit, this.volumes, this.users});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Account that = (Account)Account.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal((Object)this.type, (Object)that.type) && Objects.equal(this.networkDomain, that.networkDomain) && Objects.equal(this.domain, that.domain) && Objects.equal(this.domainId, that.domainId) && Objects.equal(this.IPsAvailable, that.IPsAvailable) && Objects.equal(this.IPLimit, that.IPLimit) && Objects.equal(this.IPs, that.IPs) && Objects.equal(this.cleanupRequired, that.cleanupRequired) && Objects.equal(this.name, that.name) && Objects.equal(this.receivedBytes, that.receivedBytes) && Objects.equal(this.sentBytes, that.sentBytes) && Objects.equal(this.snapshotsAvailable, that.snapshotsAvailable) && Objects.equal(this.snapshotLimit, that.snapshotLimit) && Objects.equal(this.snapshots, that.snapshots) && Objects.equal((Object)this.state, (Object)that.state) && Objects.equal(this.templatesAvailable, that.templatesAvailable) && Objects.equal(this.templateLimit, that.templateLimit) && Objects.equal(this.templates, that.templates) && Objects.equal(this.VMsAvailable, that.VMsAvailable) && Objects.equal(this.VMLimit, that.VMLimit) && Objects.equal(this.VMsRunning, that.VMsRunning) && Objects.equal(this.VMsStopped, that.VMsStopped) && Objects.equal(this.VMs, that.VMs) && Objects.equal(this.volumesAvailable, that.volumesAvailable) && Objects.equal(this.volumeLimit, that.volumeLimit) && Objects.equal(this.volumes, that.volumes) && Objects.equal(this.users, that.users);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).add("id", this.id).add("type", (Object)this.type).add("networkDomain", this.networkDomain).add("domain", this.domain).add("domainId", this.domainId).add("IPsAvailable", this.IPsAvailable).add("IPLimit", this.IPLimit).add("IPs", this.IPs).add("cleanupRequired", this.cleanupRequired).add("name", this.name).add("receivedBytes", this.receivedBytes).add("sentBytes", this.sentBytes).add("snapshotsAvailable", this.snapshotsAvailable).add("snapshotLimit", this.snapshotLimit).add("snapshots", this.snapshots).add("state", (Object)this.state).add("templatesAvailable", this.templatesAvailable).add("templateLimit", this.templateLimit).add("templates", this.templates).add("VMsAvailable", this.VMsAvailable).add("VMLimit", this.VMLimit).add("VMsRunning", this.VMsRunning).add("VMsStopped", this.VMsStopped).add("VMs", this.VMs).add("volumesAvailable", this.volumesAvailable).add("volumeLimit", this.volumeLimit).add("volumes", this.volumes).add("users", this.users);
    }

    @Override
    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected Type type;
        protected String networkDomain;
        protected String domain;
        protected String domainId;
        protected Long IPsAvailable;
        protected Long IPLimit;
        protected long IPs;
        protected boolean cleanupRequired;
        protected String name;
        protected long receivedBytes;
        protected long sentBytes;
        protected Long snapshotsAvailable;
        protected Long snapshotLimit;
        protected long snapshots;
        protected State state;
        protected Long templatesAvailable;
        protected Long templateLimit;
        protected long templates;
        protected Long VMsAvailable;
        protected Long VMLimit;
        protected long VMsRunning;
        protected long VMsStopped;
        protected long VMs;
        protected Long volumesAvailable;
        protected Long volumeLimit;
        protected long volumes;
        protected Set<User> users = ImmutableSet.of();

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T type(Type type) {
            this.type = type;
            return this.self();
        }

        public T networkDomain(String networkDomain) {
            this.networkDomain = networkDomain;
            return this.self();
        }

        public T domain(String domain) {
            this.domain = domain;
            return this.self();
        }

        public T domainId(String domainId) {
            this.domainId = domainId;
            return this.self();
        }

        public T IPsAvailable(Long IPsAvailable) {
            this.IPsAvailable = IPsAvailable;
            return this.self();
        }

        public T IPLimit(Long IPLimit) {
            this.IPLimit = IPLimit;
            return this.self();
        }

        public T IPs(long IPs) {
            this.IPs = IPs;
            return this.self();
        }

        public T cleanupRequired(boolean cleanupRequired) {
            this.cleanupRequired = cleanupRequired;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T receivedBytes(long receivedBytes) {
            this.receivedBytes = receivedBytes;
            return this.self();
        }

        public T sentBytes(long sentBytes) {
            this.sentBytes = sentBytes;
            return this.self();
        }

        public T snapshotsAvailable(Long snapshotsAvailable) {
            this.snapshotsAvailable = snapshotsAvailable;
            return this.self();
        }

        public T snapshotLimit(Long snapshotLimit) {
            this.snapshotLimit = snapshotLimit;
            return this.self();
        }

        public T snapshots(long snapshots) {
            this.snapshots = snapshots;
            return this.self();
        }

        public T state(State state) {
            this.state = state;
            return this.self();
        }

        public T templatesAvailable(Long templatesAvailable) {
            this.templatesAvailable = templatesAvailable;
            return this.self();
        }

        public T templateLimit(Long templateLimit) {
            this.templateLimit = templateLimit;
            return this.self();
        }

        public T templates(long templates) {
            this.templates = templates;
            return this.self();
        }

        public T VMsAvailable(Long VMsAvailable) {
            this.VMsAvailable = VMsAvailable;
            return this.self();
        }

        public T VMLimit(Long VMLimit) {
            this.VMLimit = VMLimit;
            return this.self();
        }

        public T VMsRunning(long VMsRunning) {
            this.VMsRunning = VMsRunning;
            return this.self();
        }

        public T VMsStopped(long VMsStopped) {
            this.VMsStopped = VMsStopped;
            return this.self();
        }

        public T VMs(long VMs) {
            this.VMs = VMs;
            return this.self();
        }

        public T volumesAvailable(Long volumesAvailable) {
            this.volumesAvailable = volumesAvailable;
            return this.self();
        }

        public T volumeLimit(Long volumeLimit) {
            this.volumeLimit = volumeLimit;
            return this.self();
        }

        public T volumes(long volumes) {
            this.volumes = volumes;
            return this.self();
        }

        public T users(Set<User> users) {
            this.users = ImmutableSet.copyOf((Collection)Preconditions.checkNotNull(users, "users"));
            return this.self();
        }

        public T users(User ... in) {
            return this.users(ImmutableSet.copyOf(in));
        }

        public Account build() {
            return new Account(this.id, this.type, this.networkDomain, this.domain, this.domainId, this.IPsAvailable, this.IPLimit, this.IPs, this.cleanupRequired, this.name, this.receivedBytes, this.sentBytes, this.snapshotsAvailable, this.snapshotLimit, this.snapshots, this.state, this.templatesAvailable, this.templateLimit, this.templates, this.VMsAvailable, this.VMLimit, this.VMsRunning, this.VMsStopped, this.VMs, this.volumesAvailable, this.volumeLimit, this.volumes, this.users);
        }

        public T fromAccount(Account in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).type(in.getType())).networkDomain(in.getNetworkDomain())).domain(in.getDomain())).domainId(in.getDomainId())).IPsAvailable(in.getIPsAvailable())).IPLimit(in.getIPLimit())).IPs(in.getIPs())).cleanupRequired(in.isCleanupRequired())).name(in.getName())).receivedBytes(in.getReceivedBytes())).sentBytes(in.getSentBytes())).snapshotsAvailable(in.getSnapshotsAvailable())).snapshotLimit(in.getSnapshotLimit())).snapshots(in.getSnapshots())).state(in.getState())).templatesAvailable(in.getTemplatesAvailable())).templateLimit(in.getTemplateLimit())).templates(in.getTemplates())).VMsAvailable(in.getVMsAvailable())).VMLimit(in.getVMLimit())).VMsRunning(in.getVMsRunning())).VMsStopped(in.getVMsStopped())).VMs(in.getVMs())).volumesAvailable(in.getVolumesAvailable())).volumeLimit(in.getVolumeLimit())).volumes(in.getVolumes())).users(in.getUsers());
        }
    }

    public static enum Type {
        USER(0),
        ADMIN(1),
        DOMAIN_ADMIN(2),
        UNRECOGNIZED(Integer.MAX_VALUE);

        private int code;
        private static final Map<Integer, Type> INDEX;

        private Type(int code) {
            this.code = code;
        }

        public String toString() {
            return "" + this.code;
        }

        public static Type fromValue(String type) {
            Integer code = Integer.valueOf(Preconditions.checkNotNull(type, "type"));
            return INDEX.containsKey(code) ? INDEX.get(code) : UNRECOGNIZED;
        }

        static {
            INDEX = Maps.uniqueIndex(ImmutableSet.copyOf(Type.values()), new Function<Type, Integer>(){

                @Override
                public Integer apply(Type input) {
                    return input.code;
                }
            });
        }
    }

    public static enum State {
        ENABLED,
        DISABLED,
        LOCKED,
        UNRECOGNIZED;


        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, this.name());
        }

        public static State fromValue(String state) {
            try {
                return State.valueOf(CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, Preconditions.checkNotNull(state, "state")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

