/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.apis.internal.BaseApiMetadata;
import org.jclouds.cloudstack.CloudStackAsyncClient;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.CloudStackContext;
import org.jclouds.cloudstack.compute.config.CloudStackComputeServiceContextModule;
import org.jclouds.cloudstack.config.CloudStackParserModule;
import org.jclouds.cloudstack.config.CloudStackRestClientModule;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.internal.BaseRestApiMetadata;

public class CloudStackApiMetadata
extends BaseRestApiMetadata {
    private static final long serialVersionUID = -3936131452958663245L;
    public static final TypeToken<RestContext<CloudStackClient, CloudStackAsyncClient>> CONTEXT_TOKEN = new TypeToken<RestContext<CloudStackClient, CloudStackAsyncClient>>(){
        private static final long serialVersionUID = -5070937833892503232L;
    };

    @Override
    public Builder toBuilder() {
        return new Builder().fromApiMetadata(this);
    }

    public CloudStackApiMetadata() {
        this(new Builder());
    }

    protected CloudStackApiMetadata(Builder builder) {
        super(builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseRestApiMetadata.defaultProperties();
        properties.setProperty("jclouds.ssh.max-retries", "7");
        properties.setProperty("jclouds.ssh.retry-auth", "true");
        return properties;
    }

    public static class Builder
    extends BaseRestApiMetadata.Builder {
        protected Builder() {
            super(CloudStackClient.class, CloudStackAsyncClient.class);
            ((BaseApiMetadata.Builder)this.id("cloudstack").name("Citrix CloudStack API").identityName("API Key").credentialName("Secret Key").documentation(URI.create("http://download.cloud.com/releases/2.2.0/api_2.2.12/TOC_User.html")).defaultEndpoint("http://localhost:8080/client/api").version("2.2").view(TypeToken.of(CloudStackContext.class))).defaultProperties(CloudStackApiMetadata.defaultProperties()).defaultModules((Set)((Object)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(CloudStackParserModule.class)).add(CloudStackRestClientModule.class)).add(CloudStackComputeServiceContextModule.class)).build()));
        }

        @Override
        public CloudStackApiMetadata build() {
            return new CloudStackApiMetadata(this);
        }

        @Override
        public Builder fromApiMetadata(ApiMetadata in) {
            super.fromApiMetadata(in);
            return this;
        }
    }
}

