/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ReturnStringIf2xx;

@Singleton
public class SplitNewlines
implements Function<HttpResponse, Set<String>> {
    private final ReturnStringIf2xx returnStringIf200;

    @Inject
    protected SplitNewlines(ReturnStringIf2xx returnStringIf200) {
        this.returnStringIf200 = returnStringIf200;
    }

    @Override
    public Set<String> apply(HttpResponse response) {
        return Sets.newTreeSet(Iterables.filter(Splitter.on('\n').split(this.returnStringIf200.apply(response)), Predicates.not(Predicates.equalTo(""))));
    }
}

