/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import org.jclouds.javax.annotation.Nullable;

public class SharedIpGroup {
    private final int id;
    private final String name;
    private final List<Integer> servers;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromSharedIpGroup(this);
    }

    @ConstructorProperties(value={"id", "name", "servers"})
    protected SharedIpGroup(int id, String name, @Nullable List<Integer> servers) {
        this.id = id;
        this.name = Preconditions.checkNotNull(name, "name");
        this.servers = servers == null ? null : ImmutableList.copyOf(servers);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public List<Integer> getServers() {
        return this.servers;
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.name, this.servers);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SharedIpGroup that = (SharedIpGroup)SharedIpGroup.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal(this.name, that.name) && Objects.equal(this.servers, that.servers);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).add("id", this.id).add("name", this.name).add("servers", this.servers);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected int id;
        protected String name;
        protected List<Integer> servers = null;

        protected abstract T self();

        public T id(int id) {
            this.id = id;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T servers(List<Integer> servers) {
            this.servers = ImmutableList.copyOf((Collection)Preconditions.checkNotNull(servers, "servers"));
            return this.self();
        }

        public T servers(Integer ... in) {
            return this.servers(ImmutableList.copyOf(in));
        }

        public SharedIpGroup build() {
            return new SharedIpGroup(this.id, this.name, this.servers);
        }

        public T fromSharedIpGroup(SharedIpGroup in) {
            return ((Builder)((Builder)this.id(in.getId())).name(in.getName())).servers(in.getServers());
        }
    }
}

