/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.byon.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.UncheckedExecutionException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.byon.Node;
import org.jclouds.byon.functions.NodeToNodeMetadata;
import org.jclouds.compute.JCloudsNativeComputeServiceAdapter;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.location.suppliers.all.JustProvider;

@Singleton
public class BYONComputeServiceAdapter
implements JCloudsNativeComputeServiceAdapter {
    private final Supplier<LoadingCache<String, Node>> nodes;
    private final NodeToNodeMetadata converter;
    private final JustProvider locationSupplier;

    @Inject
    public BYONComputeServiceAdapter(Supplier<LoadingCache<String, Node>> nodes, NodeToNodeMetadata converter, JustProvider locationSupplier) {
        this.nodes = Preconditions.checkNotNull(nodes, "nodes");
        this.converter = Preconditions.checkNotNull(converter, "converter");
        this.locationSupplier = Preconditions.checkNotNull(locationSupplier, "locationSupplier");
    }

    @Override
    public JCloudsNativeComputeServiceAdapter.NodeWithInitialCredentials createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<Hardware> listHardwareProfiles() {
        return ImmutableSet.of();
    }

    @Override
    public Iterable<Image> listImages() {
        return ImmutableSet.of();
    }

    @Override
    public Iterable<NodeMetadata> listNodes() {
        return Iterables.transform(this.nodes.get().asMap().values(), this.converter);
    }

    @Override
    public Iterable<Location> listLocations() {
        ImmutableSet.Builder locations = ImmutableSet.builder();
        Location provider = (Location)Iterables.getOnlyElement(this.locationSupplier.get());
        ImmutableSet<String> zones = ImmutableSet.copyOf(Iterables.filter(Iterables.transform(this.nodes.get().asMap().values(), new Function<Node, String>(){

            @Override
            public String apply(Node arg0) {
                return arg0.getLocationId();
            }
        }), Predicates.notNull()));
        if (zones.size() == 0) {
            return ((ImmutableSet.Builder)locations.add(provider)).build();
        }
        for (String zone : zones) {
            locations.add(new LocationBuilder().scope(LocationScope.ZONE).id(zone).description(zone).parent(provider).build());
        }
        return locations.build();
    }

    @Override
    public NodeMetadata getNode(String id) {
        Node node = null;
        try {
            node = this.nodes.get().getUnchecked(id);
        }
        catch (UncheckedExecutionException uncheckedExecutionException) {
            // empty catch block
        }
        return node != null ? this.converter.apply(node) : null;
    }

    @Override
    public Image getImage(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void destroyNode(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rebootNode(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resumeNode(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void suspendNode(String id) {
        throw new UnsupportedOperationException();
    }
}

