/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.InputStreamMap;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.blobstore.internal.BaseBlobMap;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.strategy.ContainsValueInListStrategy;
import org.jclouds.blobstore.strategy.GetBlobsInListStrategy;
import org.jclouds.blobstore.strategy.PutBlobsStrategy;
import org.jclouds.blobstore.strategy.internal.ListContainerAndRecurseThroughFolders;
import org.jclouds.crypto.Crypto;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.ByteArrayPayload;
import org.jclouds.io.payloads.FilePayload;
import org.jclouds.io.payloads.InputStreamPayload;
import org.jclouds.io.payloads.StringPayload;

public class InputStreamMapImpl
extends BaseBlobMap<InputStream>
implements InputStreamMap {
    protected final Crypto crypto;

    @Inject
    public InputStreamMapImpl(BlobStore connection, Provider<BlobBuilder> blobBuilders, GetBlobsInListStrategy getAllBlobs, ListContainerAndRecurseThroughFolders listStrategy, ContainsValueInListStrategy containsValueStrategy, PutBlobsStrategy putBlobsStrategy, String containerName, ListContainerOptions options, Crypto crypto) {
        super(connection, getAllBlobs, containsValueStrategy, putBlobsStrategy, listStrategy, containerName, options);
        this.crypto = crypto;
    }

    @Override
    public InputStream get(Object o) {
        String realKey = (String)this.prefixer.apply(o.toString());
        Blob blob = this.blobstore.getBlob(this.containerName, realKey);
        return this.getInputStreamOrNull(blob);
    }

    private InputStream getInputStreamOrNull(Blob blob) {
        return blob != null ? (blob.getPayload() != null ? blob.getPayload().getInput() : null) : null;
    }

    @Override
    public InputStream remove(Object o) {
        InputStream old = this.get(o);
        String realKey = (String)this.prefixer.apply(o.toString());
        this.blobstore.removeBlob(this.containerName, realKey);
        return old;
    }

    @Override
    public Collection<InputStream> values() {
        return Lists.newArrayList(Iterables.transform(this.getAllBlobs.execute(this.containerName, this.options), new Function<Blob, InputStream>(){

            @Override
            public InputStream apply(Blob from) {
                return InputStreamMapImpl.this.getInputStreamOrNull(from);
            }
        }));
    }

    @Override
    public void putAll(Map<? extends String, ? extends InputStream> map) {
        this.putAllInternal(map);
    }

    @Override
    public void putAllBytes(Map<? extends String, ? extends byte[]> map) {
        this.putAllInternal(map);
    }

    @Override
    public void putAllFiles(Map<? extends String, ? extends File> map) {
        this.putAllInternal(map);
    }

    @Override
    public void putAllStrings(Map<? extends String, ? extends String> map) {
        this.putAllInternal(map);
    }

    @VisibleForTesting
    void putAllInternal(Map<? extends String, ? extends Object> map) {
        this.putBlobsStrategy.execute(this.containerName, Iterables.transform(map.entrySet(), new Function<Map.Entry<? extends String, ? extends Object>, Blob>(){

            @Override
            public Blob apply(Map.Entry<? extends String, ? extends Object> from) {
                String name = from.getKey();
                Object value = from.getValue();
                return InputStreamMapImpl.this.newBlobWithMD5(name, value);
            }
        }));
    }

    @VisibleForTesting
    Blob newBlobWithMD5(String name, Object value) {
        Blob blob = this.blobstore.blobBuilder((String)this.prefixer.apply(name)).payload(Payloads.newPayload(value)).build();
        try {
            Payloads.calculateMD5(blob, this.crypto.md5());
        }
        catch (IOException e) {
            Throwables.propagate(e);
        }
        return blob;
    }

    @Override
    public InputStream putString(String key, String value) {
        return this.putInternal(key, new StringPayload(value));
    }

    @Override
    public InputStream putFile(String key, File value) {
        return this.putInternal(key, new FilePayload(value));
    }

    @Override
    public InputStream putBytes(String key, byte[] value) {
        return this.putInternal(key, new ByteArrayPayload(value));
    }

    @Override
    public InputStream put(String key, InputStream value) {
        return this.putInternal(key, new InputStreamPayload(value));
    }

    @VisibleForTesting
    InputStream putInternal(String name, Payload payload) {
        InputStream returnVal = this.containsKey(name) ? this.get(name) : null;
        Blob blob = this.newBlobWithMD5(name, payload);
        this.blobstore.putBlob(this.containerName, blob);
        return returnVal;
    }
}

