/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.internal;

import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import com.google.common.reflect.TypeToken;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.Context;
import org.jclouds.blobstore.AsyncBlobStore;
import org.jclouds.blobstore.BlobMap;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.InputStreamMap;
import org.jclouds.blobstore.attr.ConsistencyModel;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.internal.BaseView;
import org.jclouds.location.Provider;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.Utils;

@Singleton
public class BlobStoreContextImpl
extends BaseView
implements BlobStoreContext {
    private final BlobMap.Factory blobMapFactory;
    private final InputStreamMap.Factory inputStreamMapFactory;
    private final AsyncBlobStore ablobStore;
    private final BlobStore blobStore;
    private final ConsistencyModel consistencyModel;
    private final Utils utils;
    private final BlobRequestSigner blobRequestSigner;

    @Inject
    public BlobStoreContextImpl(@Provider Context backend, @Provider TypeToken<? extends Context> backendType, BlobMap.Factory blobMapFactory, Utils utils, ConsistencyModel consistencyModel, InputStreamMap.Factory inputStreamMapFactory, AsyncBlobStore ablobStore, BlobStore blobStore, BlobRequestSigner blobRequestSigner) {
        super(backend, backendType);
        this.consistencyModel = Preconditions.checkNotNull(consistencyModel, "consistencyModel");
        this.blobMapFactory = Preconditions.checkNotNull(blobMapFactory, "blobMapFactory");
        this.inputStreamMapFactory = Preconditions.checkNotNull(inputStreamMapFactory, "inputStreamMapFactory");
        this.ablobStore = Preconditions.checkNotNull(ablobStore, "ablobStore");
        this.blobStore = Preconditions.checkNotNull(blobStore, "blobStore");
        this.utils = Preconditions.checkNotNull(utils, "utils");
        this.blobRequestSigner = Preconditions.checkNotNull(blobRequestSigner, "blobRequestSigner");
    }

    @Override
    public ConsistencyModel getConsistencyModel() {
        return this.consistencyModel;
    }

    @Override
    public BlobMap createBlobMap(String container, ListContainerOptions options) {
        return this.blobMapFactory.create(container, options);
    }

    @Override
    public BlobMap createBlobMap(String container) {
        return this.blobMapFactory.create(container, ListContainerOptions.NONE);
    }

    @Override
    public InputStreamMap createInputStreamMap(String container, ListContainerOptions options) {
        return this.inputStreamMapFactory.create(container, options);
    }

    @Override
    public InputStreamMap createInputStreamMap(String container) {
        return this.inputStreamMapFactory.create(container, ListContainerOptions.NONE);
    }

    @Override
    public BlobStore getBlobStore() {
        return this.blobStore;
    }

    @Override
    public AsyncBlobStore getAsyncBlobStore() {
        return this.ablobStore;
    }

    @Override
    public Utils getUtils() {
        return this.utils();
    }

    @Override
    public Utils utils() {
        return this.utils;
    }

    @Override
    public BlobRequestSigner getSigner() {
        return this.blobRequestSigner;
    }

    @Override
    public <S, A> RestContext<S, A> getProviderSpecificContext() {
        return (RestContext)this.delegate();
    }

    @Override
    public void close() {
        Closeables.closeQuietly(this.delegate());
    }

    @Override
    public int hashCode() {
        return this.delegate().hashCode();
    }

    @Override
    public String toString() {
        return this.delegate().toString();
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate().equals(obj);
    }
}

