/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.config;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import javax.inject.Inject;
import javax.inject.Provider;
import org.jclouds.azureblob.domain.AzureBlob;
import org.jclouds.azureblob.domain.MutableBlobProperties;
import org.jclouds.azureblob.domain.internal.AzureBlobImpl;
import org.jclouds.blobstore.config.BlobStoreObjectModule;

public class AzureBlobModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.install(new BlobStoreObjectModule());
        this.bind(AzureBlob.Factory.class).to(AzureBlobFactory.class).in(Scopes.SINGLETON);
    }

    @Provides
    AzureBlob provideAzureBlob(AzureBlob.Factory factory) {
        return factory.create(null);
    }

    private static class AzureBlobFactory
    implements AzureBlob.Factory {
        @Inject
        Provider<MutableBlobProperties> metadataProvider;

        private AzureBlobFactory() {
        }

        @Override
        public AzureBlob create(MutableBlobProperties metadata) {
            return new AzureBlobImpl(metadata != null ? metadata : this.metadataProvider.get());
        }
    }
}

