/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.xml;

import com.google.common.base.Supplier;
import javax.inject.Inject;
import org.jclouds.aws.ec2.domain.PlacementGroup;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.location.Region;

public class PlacementGroupHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<PlacementGroup> {
    private StringBuilder currentText = new StringBuilder();
    @Inject
    @Region
    Supplier<String> defaultRegion;
    private String name;
    private String strategy = "cluster";
    private PlacementGroup.State state;

    @Override
    public PlacementGroup getResult() {
        String region = AWSUtils.findRegionInArgsOrNull(this.getRequest());
        if (region == null) {
            region = this.defaultRegion.get();
        }
        PlacementGroup returnVal = new PlacementGroup(region, this.name, this.strategy, this.state);
        this.name = null;
        this.strategy = "cluster";
        this.state = null;
        return returnVal;
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (qName.equals("groupName")) {
            this.name = this.currentText.toString().trim();
        } else if (qName.equals("strategy")) {
            this.strategy = this.currentText.toString().trim();
        } else if (qName.equals("state")) {
            this.state = PlacementGroup.State.fromValue(this.currentText.toString().trim());
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

