/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.xml;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.jclouds.vcloud.domain.NetworkConnection;
import org.jclouds.vcloud.domain.NetworkConnectionSection;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.util.Utils;
import org.jclouds.vcloud.xml.NetworkConnectionHandler;
import org.xml.sax.Attributes;

public class NetworkConnectionSectionHandler
extends ParseSax.HandlerWithResult<NetworkConnectionSection> {
    protected StringBuilder currentText = new StringBuilder();
    private final NetworkConnectionHandler networkConnectionHandler;
    protected String info;
    protected Set<NetworkConnection> connections = Sets.newLinkedHashSet();
    protected ReferenceType section;
    protected ReferenceType edit;
    protected Integer primaryNetworkConnectionIndex;
    protected boolean inConnections;

    @Inject
    public NetworkConnectionSectionHandler(NetworkConnectionHandler networkConnectionHandler) {
        this.networkConnectionHandler = networkConnectionHandler;
    }

    @Override
    public NetworkConnectionSection getResult() {
        return new NetworkConnectionSection(this.section.getType(), this.section.getHref(), this.info, this.primaryNetworkConnectionIndex, this.connections, this.edit);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        Map<String, String> attributes = SaxUtils.cleanseAttributes(attrs);
        if (qName.endsWith("NetworkConnection")) {
            this.inConnections = true;
        }
        if (this.inConnections) {
            this.networkConnectionHandler.startElement(uri, localName, qName, attrs);
        } else if (qName.endsWith("NetworkConnectionSection")) {
            this.section = Utils.newReferenceType(attributes);
        } else if (qName.endsWith("Link") && "edit".equals(attributes.get("rel"))) {
            this.edit = Utils.newReferenceType(attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (qName.endsWith("NetworkConnection")) {
            this.inConnections = false;
            this.connections.add(this.networkConnectionHandler.getResult());
        }
        if (this.inConnections) {
            this.networkConnectionHandler.endElement(uri, localName, qName);
        } else if (qName.endsWith("Info")) {
            this.info = this.currentOrNull();
        } else if (qName.endsWith("PrimaryNetworkConnectionIndex")) {
            this.primaryNetworkConnectionIndex = Integer.valueOf(this.currentOrNull());
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.inConnections) {
            this.networkConnectionHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }

    protected String currentOrNull() {
        String returnVal = this.currentText.toString().trim();
        return returnVal.equals("") ? null : returnVal;
    }
}

