/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.functions;

import com.google.common.base.Function;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;
import org.jclouds.trmk.vcloud_0_8.TerremarkVCloudAsyncClient;
import org.jclouds.trmk.vcloud_0_8.domain.Catalog;
import org.jclouds.trmk.vcloud_0_8.domain.Org;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;

@Singleton
public class AllCatalogsInOrg
implements Function<Org, Iterable<? extends Catalog>> {
    @Resource
    public Logger logger = Logger.NULL;
    private final TerremarkVCloudAsyncClient aclient;
    private final ExecutorService executor;

    @Inject
    AllCatalogsInOrg(TerremarkVCloudAsyncClient aclient, @Named(value="jclouds.user-threads") ExecutorService executor) {
        this.aclient = aclient;
        this.executor = executor;
    }

    @Override
    public Iterable<? extends Catalog> apply(Org org) {
        Iterable<? extends Catalog> catalogs = FutureIterables.transformParallel(org.getCatalogs().values(), new Function<ReferenceType, Future<? extends Catalog>>(){

            @Override
            public Future<Catalog> apply(ReferenceType from) {
                return AllCatalogsInOrg.this.aclient.getCatalog(from.getHref());
            }
        }, this.executor, null, this.logger, "catalogs in " + org.getName());
        return catalogs;
    }
}

