/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.domain;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.List;
import org.jclouds.trmk.vcloud_0_8.domain.ComputePoolReference;
import org.jclouds.trmk.vcloud_0_8.domain.NetworkAdapter;

public class VAppExtendedInfo
implements Comparable<VAppExtendedInfo> {
    private final String id;
    private final URI href;
    private final String name;
    private final String longName;
    private final List<String> tags;
    private final List<NetworkAdapter> networkAdapters;
    private final ComputePoolReference computePoolReference;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return VAppExtendedInfo.builder().fromVAppExtendedInfo(this);
    }

    public VAppExtendedInfo(String id, URI href, String name, List<String> tags, String longName, List<NetworkAdapter> networkAdapters, ComputePoolReference computePoolReference) {
        this.id = id;
        this.href = href;
        this.name = name;
        this.tags = tags;
        this.longName = longName;
        this.networkAdapters = networkAdapters;
        this.computePoolReference = computePoolReference;
    }

    @Override
    public int compareTo(VAppExtendedInfo that) {
        return this == that ? 0 : this.getHref().compareTo(that.getHref());
    }

    public String getId() {
        return this.id;
    }

    public URI getHref() {
        return this.href;
    }

    public String getName() {
        return this.name;
    }

    public String getLongName() {
        return this.longName;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public List<NetworkAdapter> getNetworkAdapters() {
        return this.networkAdapters;
    }

    public ComputePoolReference getComputePoolReference() {
        return this.computePoolReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VAppExtendedInfo that = (VAppExtendedInfo)VAppExtendedInfo.class.cast(o);
        return Objects.equal(this.id, that.id) && Objects.equal(this.href, that.href) && Objects.equal(this.name, that.name) && Objects.equal(this.longName, that.longName) && Objects.equal(this.tags, that.tags) && Objects.equal(this.networkAdapters, that.networkAdapters) && Objects.equal(this.computePoolReference, that.computePoolReference);
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.href, this.name, this.longName, this.tags, this.networkAdapters, this.computePoolReference);
    }

    public String toString() {
        return Objects.toStringHelper("").add("id", this.id).add("href", this.href).add("name", this.name).add("longName", this.longName).add("tags", this.tags).add("networkAdapters", this.networkAdapters).add("computePoolReference", this.computePoolReference).toString();
    }

    public static class Builder {
        private String id;
        private URI href;
        private String name;
        private String longName;
        private List<String> tags = Lists.newArrayList();
        private List<NetworkAdapter> networkAdapters = Lists.newArrayList();
        private ComputePoolReference computePoolReference;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder href(URI href) {
            this.href = href;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder longName(String longName) {
            this.longName = longName;
            return this;
        }

        public Builder tags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        public Builder networkAdapters(List<NetworkAdapter> networkAdapters) {
            this.networkAdapters = networkAdapters;
            return this;
        }

        public Builder networkAdapter(NetworkAdapter networkAdapter) {
            this.networkAdapters.add(networkAdapter);
            return this;
        }

        public Builder computePoolReference(ComputePoolReference computePoolReference) {
            this.computePoolReference = computePoolReference;
            return this;
        }

        public VAppExtendedInfo build() {
            return new VAppExtendedInfo(this.id, this.href, this.name, this.tags, this.longName, this.networkAdapters, this.computePoolReference);
        }

        public Builder fromVAppExtendedInfo(VAppExtendedInfo in) {
            return this.id(in.getId()).href(in.getHref()).name(in.getName()).longName(in.getLongName()).tags(in.getTags()).networkAdapters(in.getNetworkAdapters()).computePoolReference(in.getComputePoolReference());
        }
    }
}

