/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cim.OSType;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.CIMOperatingSystem;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.trmk.vcloud_0_8.compute.TerremarkVCloudComputeClient;
import org.jclouds.trmk.vcloud_0_8.compute.functions.FindLocationForResource;
import org.jclouds.trmk.vcloud_0_8.compute.functions.HardwareForVCloudExpressVApp;
import org.jclouds.trmk.vcloud_0_8.domain.Status;
import org.jclouds.trmk.vcloud_0_8.domain.VApp;

@Singleton
public class VAppToNodeMetadata
implements Function<VApp, NodeMetadata> {
    protected final TerremarkVCloudComputeClient computeClient;
    protected final Map<String, Credentials> credentialStore;
    protected final Supplier<Set<? extends Image>> images;
    protected final FindLocationForResource findLocationForResourceInVDC;
    protected final HardwareForVCloudExpressVApp hardwareForVCloudExpressVApp;
    protected final Map<Status, NodeMetadata.Status> vAppStatusToNodeStatus;
    protected final GroupNamingConvention nodeNamingConvention;

    @Inject
    protected VAppToNodeMetadata(TerremarkVCloudComputeClient computeClient, Map<String, Credentials> credentialStore, Map<Status, NodeMetadata.Status> vAppStatusToNodeStatus, HardwareForVCloudExpressVApp hardwareForVCloudExpressVApp, FindLocationForResource findLocationForResourceInVDC, @Memoized Supplier<Set<? extends Image>> images, GroupNamingConvention.Factory namingConvention) {
        this.nodeNamingConvention = Preconditions.checkNotNull(namingConvention, "namingConvention").createWithoutPrefix();
        this.images = Preconditions.checkNotNull(images, "images");
        this.hardwareForVCloudExpressVApp = Preconditions.checkNotNull(hardwareForVCloudExpressVApp, "hardwareForVCloudExpressVApp");
        this.findLocationForResourceInVDC = Preconditions.checkNotNull(findLocationForResourceInVDC, "findLocationForResourceInVDC");
        this.credentialStore = Preconditions.checkNotNull(credentialStore, "credentialStore");
        this.computeClient = Preconditions.checkNotNull(computeClient, "computeClient");
        this.vAppStatusToNodeStatus = Preconditions.checkNotNull(vAppStatusToNodeStatus, "vAppStatusToNodeStatus");
    }

    @Override
    public NodeMetadata apply(VApp from) {
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.ids(from.getHref().toASCIIString());
        builder.uri(from.getHref());
        builder.name(from.getName());
        builder.hostname(from.getName());
        Location vdcLocation = this.findLocationForResourceInVDC.apply(from.getVDC());
        builder.location(vdcLocation);
        if (from.getOsType() != null && OSType.fromValue(from.getOsType()) != OSType.UNRECOGNIZED) {
            builder.operatingSystem(new CIMOperatingSystem(OSType.fromValue(from.getOsType()), "", null, from.getOperatingSystemDescription()));
        } else if (from.getOperatingSystemDescription() != null) {
            OperatingSystem.Builder osBuilder = new OperatingSystem.Builder();
            if (from.getOsType() != null) {
                osBuilder.name(from.getOsType() + "");
            }
            osBuilder.family(ComputeServiceUtils.parseOsFamilyOrUnrecognized(from.getOperatingSystemDescription()));
            osBuilder.version("");
            osBuilder.is64Bit(from.getOperatingSystemDescription().indexOf("64") != -1);
            osBuilder.description(from.getOperatingSystemDescription());
            builder.operatingSystem(osBuilder.build());
        }
        builder.hardware(this.hardwareForVCloudExpressVApp.apply(from));
        builder.status(this.vAppStatusToNodeStatus.get((Object)from.getStatus()));
        builder.publicAddresses(this.computeClient.getPublicAddresses(from.getHref()));
        builder.privateAddresses(this.computeClient.getPrivateAddresses(from.getHref()));
        builder.group(this.nodeNamingConvention.groupInUniqueNameOrNull(from.getName()));
        builder.credentials(LoginCredentials.fromCredentials(this.credentialStore.get("node#" + from.getHref().toASCIIString())));
        return builder.build();
    }
}

