/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute.functions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Image;
import org.jclouds.trmk.vcloud_0_8.compute.functions.ImageForVCloudExpressVAppTemplate;
import org.jclouds.trmk.vcloud_0_8.domain.CatalogItem;
import org.jclouds.trmk.vcloud_0_8.domain.Org;
import org.jclouds.trmk.vcloud_0_8.domain.VAppTemplate;
import org.jclouds.trmk.vcloud_0_8.functions.AllCatalogItemsInOrg;

@Singleton
public class ImagesInVCloudExpressOrg
implements Function<Org, Iterable<? extends Image>> {
    private final AllCatalogItemsInOrg allCatalogItemsInOrg;
    private final Function<Iterable<? extends CatalogItem>, Iterable<? extends VAppTemplate>> vAppTemplatesForCatalogItems;
    private final Provider<ImageForVCloudExpressVAppTemplate> imageForVAppTemplateProvider;

    @Inject
    ImagesInVCloudExpressOrg(AllCatalogItemsInOrg allCatalogItemsInOrg, Provider<ImageForVCloudExpressVAppTemplate> imageForVAppTemplateProvider, Function<Iterable<? extends CatalogItem>, Iterable<? extends VAppTemplate>> vAppTemplatesForCatalogItems) {
        this.imageForVAppTemplateProvider = imageForVAppTemplateProvider;
        this.allCatalogItemsInOrg = allCatalogItemsInOrg;
        this.vAppTemplatesForCatalogItems = vAppTemplatesForCatalogItems;
    }

    @Override
    public Iterable<? extends Image> apply(Org from) {
        Iterable<? extends CatalogItem> catalogs = this.allCatalogItemsInOrg.apply(from);
        Iterable<? extends VAppTemplate> vAppTemplates = this.vAppTemplatesForCatalogItems.apply(catalogs);
        return Iterables.transform(vAppTemplates, this.imageForVAppTemplateProvider.get().withParent(from));
    }
}

