/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.binders;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.jamesmurty.utils.XMLBuilder;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.jclouds.cim.ResourceAllocationSettingData;
import org.jclouds.http.HttpRequest;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToStringPayload;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.endpoints.Network;
import org.jclouds.trmk.vcloud_0_8.options.InstantiateVAppTemplateOptions;

@Singleton
public class BindInstantiateVAppTemplateParamsToXmlPayload
implements MapBinder {
    protected final String ns;
    protected final String schema;
    private final BindToStringPayload stringBinder;
    protected final Map<ResourceAllocationSettingData.ResourceType, String> virtualHardwareToInstanceId = ImmutableMap.of(ResourceAllocationSettingData.ResourceType.PROCESSOR, "1", ResourceAllocationSettingData.ResourceType.MEMORY, "2", ResourceAllocationSettingData.ResourceType.DISK_DRIVE, "9");
    private final Supplier<ReferenceType> defaultNetwork;
    private final String defaultFenceMode;
    ThreadLocal<Map<String, String>> propLocal = new ThreadLocal();

    @Inject
    public BindInstantiateVAppTemplateParamsToXmlPayload(BindToStringPayload stringBinder, @Named(value="jclouds.vcloud.xml.ns") String ns, @Named(value="jclouds.vcloud.xml.schema") String schema, @Network Supplier<ReferenceType> network, @Named(value="jclouds.vcloud.defaults.fencemode") String fenceMode) {
        this.ns = ns;
        this.schema = schema;
        this.stringBinder = stringBinder;
        this.defaultNetwork = network;
        this.defaultFenceMode = fenceMode;
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        Preconditions.checkArgument(Preconditions.checkNotNull(request, "request") instanceof GeneratedHttpRequest, "this binder is only valid for GeneratedHttpRequests!");
        GeneratedHttpRequest gRequest = (GeneratedHttpRequest)request;
        Preconditions.checkState(gRequest.getArgs() != null, "args should be initialized at this point");
        String name = Preconditions.checkNotNull(postParams.remove("name"), "name").toString();
        String template = Preconditions.checkNotNull(postParams.remove("template"), "template").toString();
        TreeMap<ResourceAllocationSettingData.ResourceType, String> virtualHardwareQuantity = Maps.newTreeMap();
        InstantiateVAppTemplateOptions options = this.findOptionsInArgsOrNull(gRequest);
        String network = this.defaultNetwork != null ? this.defaultNetwork.get().getHref().toASCIIString() : null;
        String fenceMode = this.defaultFenceMode;
        String networkName = name;
        if (options != null) {
            if (options.getNetworkConfig().size() > 0) {
                InstantiateVAppTemplateOptions.NetworkConfig config = Iterables.get(options.getNetworkConfig(), 0);
                network = this.ifNullDefaultTo(config.getParentNetwork(), network);
                fenceMode = this.ifNullDefaultTo((Object)config.getFenceMode(), this.defaultFenceMode);
                networkName = this.ifNullDefaultTo(config.getNetworkName(), networkName);
            }
            this.addQuantity(options, virtualHardwareQuantity);
        }
        try {
            return this.stringBinder.bindToRequest(request, this.generateXml(name, template, virtualHardwareQuantity, networkName, fenceMode, URI.create(network)));
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    protected String generateXml(String name, String template, SortedMap<ResourceAllocationSettingData.ResourceType, String> virtualHardwareQuantity, String networkName, @Nullable String fenceMode, URI network) throws ParserConfigurationException, FactoryConfigurationError, TransformerException {
        XMLBuilder rootBuilder = this.buildRoot(name);
        rootBuilder.e("VAppTemplate").a("href", template);
        XMLBuilder instantiationParamsBuilder = rootBuilder.e("InstantiationParams");
        this.addVirtualQuantityIfPresent(instantiationParamsBuilder, virtualHardwareQuantity);
        this.addNetworkConfig(instantiationParamsBuilder, networkName, fenceMode, network);
        Properties outputProperties = new Properties();
        outputProperties.put("omit-xml-declaration", "yes");
        return rootBuilder.asString(outputProperties);
    }

    protected void addNetworkConfig(XMLBuilder instantiationParamsBuilder, String name, @Nullable String fenceMode, URI network) {
        XMLBuilder networkConfigBuilder = instantiationParamsBuilder.e("NetworkConfigSection").e("NetworkConfig").a("name", name);
        if (fenceMode != null) {
            XMLBuilder featuresBuilder = networkConfigBuilder.e("Features");
            featuresBuilder.e("FenceMode").t(fenceMode);
        }
        networkConfigBuilder.e("NetworkAssociation").a("href", network.toASCIIString());
    }

    protected XMLBuilder buildRoot(String name) throws ParserConfigurationException, FactoryConfigurationError {
        XMLBuilder rootBuilder = XMLBuilder.create("InstantiateVAppTemplateParams").a("name", name).a("xmlns", this.ns).a("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance").a("xsi:schemaLocation", this.ns + " " + this.schema).a("xmlns:ovf", "http://schemas.dmtf.org/ovf/envelope/1");
        return rootBuilder;
    }

    private void addQuantity(InstantiateVAppTemplateOptions options, Map<ResourceAllocationSettingData.ResourceType, String> virtualHardwareQuantity) {
        if (options.getCpuCount() != null) {
            virtualHardwareQuantity.put(ResourceAllocationSettingData.ResourceType.PROCESSOR, options.getCpuCount());
        }
        if (options.getMemorySizeMegabytes() != null) {
            virtualHardwareQuantity.put(ResourceAllocationSettingData.ResourceType.MEMORY, options.getMemorySizeMegabytes());
        }
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        throw new IllegalStateException("InstantiateVAppTemplateParams is needs parameters");
    }

    protected String ifNullDefaultTo(Object value, String defaultValue) {
        return value != null ? value.toString() : Preconditions.checkNotNull(defaultValue, "defaultValue");
    }

    protected InstantiateVAppTemplateOptions findOptionsInArgsOrNull(GeneratedHttpRequest gRequest) {
        InstantiateVAppTemplateOptions options = null;
        for (Object arg : gRequest.getArgs()) {
            if (arg instanceof InstantiateVAppTemplateOptions) {
                options = (InstantiateVAppTemplateOptions)arg;
                continue;
            }
            if (!(arg instanceof InstantiateVAppTemplateOptions[])) continue;
            InstantiateVAppTemplateOptions[] optionsA = (InstantiateVAppTemplateOptions[])arg;
            options = optionsA.length > 0 ? optionsA[0] : null;
        }
        if (options != null) {
            this.propLocal.set(options.getProperties());
        }
        return options;
    }

    protected void addVirtualQuantityIfPresent(XMLBuilder instantiationParamsBuilder, SortedMap<ResourceAllocationSettingData.ResourceType, String> virtualHardwareQuantity) {
        XMLBuilder productSectionBuilder = instantiationParamsBuilder.e("ProductSection").a("xmlns:q1", this.ns).a("xmlns:ovf", "http://schemas.dmtf.org/ovf/envelope/1");
        if (this.propLocal.get() != null) {
            for (Map.Entry<String, String> entry : this.propLocal.get().entrySet()) {
                productSectionBuilder.e("Property").a("xmlns", "http://schemas.dmtf.org/ovf/envelope/1").a("ovf:key", entry.getKey()).a("ovf:value", entry.getValue());
            }
            this.propLocal.set(null);
        }
        if (virtualHardwareQuantity.size() > 0) {
            XMLBuilder virtualHardwareSectionBuilder = instantiationParamsBuilder.e("VirtualHardwareSection").a("xmlns:q1", this.ns);
            for (Map.Entry<ResourceAllocationSettingData.ResourceType, String> entry : virtualHardwareQuantity.entrySet()) {
                XMLBuilder itemBuilder = virtualHardwareSectionBuilder.e("Item").a("xmlns", "http://schemas.dmtf.org/ovf/envelope/1");
                itemBuilder.e("InstanceID").a("xmlns", "http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_ResourceAllocationSettingData").t(this.virtualHardwareToInstanceId.get((Object)entry.getKey()));
                itemBuilder.e("ResourceType").a("xmlns", "http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_ResourceAllocationSettingData").t(entry.getKey().value());
                itemBuilder.e("VirtualQuantity").a("xmlns", "http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_ResourceAllocationSettingData").t(entry.getValue());
            }
        }
    }
}

