/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.features;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Table;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.rest.functions.ReturnVoidOnNotFoundOr404;
import org.jclouds.sqs.binders.BindChangeMessageVisibilityBatchRequestEntryToIndexedFormParams;
import org.jclouds.sqs.binders.BindDeleteMessageBatchRequestEntryToIndexedFormParams;
import org.jclouds.sqs.binders.BindSendMessageBatchRequestEntryToIndexedFormParams;
import org.jclouds.sqs.binders.BindSendMessageBatchRequestEntryWithDelaysToIndexedFormParams;
import org.jclouds.sqs.domain.BatchResult;
import org.jclouds.sqs.domain.Message;
import org.jclouds.sqs.domain.MessageIdAndMD5;
import org.jclouds.sqs.options.ReceiveMessageOptions;
import org.jclouds.sqs.options.SendMessageOptions;
import org.jclouds.sqs.xml.ChangeMessageVisibilityBatchResponseHandler;
import org.jclouds.sqs.xml.DeleteMessageBatchResponseHandler;
import org.jclouds.sqs.xml.MessageHandler;
import org.jclouds.sqs.xml.ReceiveMessageResponseHandler;
import org.jclouds.sqs.xml.RegexMessageIdAndMD5Handler;
import org.jclouds.sqs.xml.SendMessageBatchResponseHandler;

@RequestFilters(value={FormSigner.class})
@FormParams(keys={"Version"}, values={"{jclouds.api-version}"})
@VirtualHost
public interface MessageAsyncApi {
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DeleteMessage"})
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    public ListenableFuture<Void> delete(@FormParam(value="ReceiptHandle") String var1);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DeleteMessageBatch"})
    @XMLResponseParser(value=DeleteMessageBatchResponseHandler.class)
    public ListenableFuture<? extends BatchResult<String>> delete(@BinderParam(value=BindDeleteMessageBatchRequestEntryToIndexedFormParams.class) Map<String, String> var1);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DeleteMessageBatch"})
    @XMLResponseParser(value=DeleteMessageBatchResponseHandler.class)
    public ListenableFuture<? extends BatchResult<String>> delete(@BinderParam(value=BindDeleteMessageBatchRequestEntryToIndexedFormParams.class) Iterable<String> var1);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"ChangeMessageVisibility"})
    public ListenableFuture<Void> changeVisibility(@FormParam(value="ReceiptHandle") String var1, @FormParam(value="VisibilityTimeout") int var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"ChangeMessageVisibilityBatch"})
    @XMLResponseParser(value=ChangeMessageVisibilityBatchResponseHandler.class)
    public ListenableFuture<? extends BatchResult<String>> changeVisibility(@BinderParam(value=BindChangeMessageVisibilityBatchRequestEntryToIndexedFormParams.class) Table<String, String, Integer> var1);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"ChangeMessageVisibilityBatch"})
    @XMLResponseParser(value=ChangeMessageVisibilityBatchResponseHandler.class)
    public ListenableFuture<? extends BatchResult<String>> changeVisibility(@BinderParam(value=BindChangeMessageVisibilityBatchRequestEntryToIndexedFormParams.class) Map<String, Integer> var1);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"ChangeMessageVisibilityBatch"})
    @MapBinder(value=BindChangeMessageVisibilityBatchRequestEntryToIndexedFormParams.class)
    @XMLResponseParser(value=ChangeMessageVisibilityBatchResponseHandler.class)
    public ListenableFuture<? extends BatchResult<String>> changeVisibility(@PayloadParam(value="idReceiptHandle") Map<String, String> var1, @PayloadParam(value="visibilityTimeout") int var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"ChangeMessageVisibilityBatch"})
    @MapBinder(value=BindChangeMessageVisibilityBatchRequestEntryToIndexedFormParams.class)
    @XMLResponseParser(value=ChangeMessageVisibilityBatchResponseHandler.class)
    public ListenableFuture<? extends BatchResult<String>> changeVisibility(@PayloadParam(value="receiptHandles") Iterable<String> var1, @PayloadParam(value="visibilityTimeout") int var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"SendMessage"})
    @ResponseParser(value=RegexMessageIdAndMD5Handler.class)
    public ListenableFuture<? extends MessageIdAndMD5> send(@FormParam(value="MessageBody") String var1);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"SendMessage"})
    @ResponseParser(value=RegexMessageIdAndMD5Handler.class)
    public ListenableFuture<? extends MessageIdAndMD5> send(@FormParam(value="MessageBody") String var1, SendMessageOptions var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"SendMessageBatch"})
    @ResponseParser(value=RegexMessageIdAndMD5Handler.class)
    @XMLResponseParser(value=SendMessageBatchResponseHandler.class)
    public ListenableFuture<? extends BatchResult<? extends MessageIdAndMD5>> sendWithDelays(@BinderParam(value=BindSendMessageBatchRequestEntryWithDelaysToIndexedFormParams.class) Table<String, String, Integer> var1);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"SendMessageBatch"})
    @ResponseParser(value=RegexMessageIdAndMD5Handler.class)
    @XMLResponseParser(value=SendMessageBatchResponseHandler.class)
    public ListenableFuture<? extends BatchResult<? extends MessageIdAndMD5>> sendWithDelays(@BinderParam(value=BindSendMessageBatchRequestEntryWithDelaysToIndexedFormParams.class) Map<String, Integer> var1);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"SendMessageBatch"})
    @MapBinder(value=BindSendMessageBatchRequestEntryWithDelaysToIndexedFormParams.class)
    @XMLResponseParser(value=SendMessageBatchResponseHandler.class)
    public ListenableFuture<? extends BatchResult<? extends MessageIdAndMD5>> sendWithDelay(@PayloadParam(value="idMessageBody") Map<String, String> var1, @PayloadParam(value="delaySeconds") int var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"SendMessageBatch"})
    @MapBinder(value=BindSendMessageBatchRequestEntryWithDelaysToIndexedFormParams.class)
    @XMLResponseParser(value=SendMessageBatchResponseHandler.class)
    public ListenableFuture<? extends BatchResult<? extends MessageIdAndMD5>> sendWithDelay(@PayloadParam(value="messageBodies") Iterable<String> var1, @PayloadParam(value="delaySeconds") int var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"SendMessageBatch"})
    @XMLResponseParser(value=SendMessageBatchResponseHandler.class)
    public ListenableFuture<? extends BatchResult<? extends MessageIdAndMD5>> send(@BinderParam(value=BindSendMessageBatchRequestEntryToIndexedFormParams.class) Map<String, String> var1);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"SendMessageBatch"})
    @XMLResponseParser(value=SendMessageBatchResponseHandler.class)
    public ListenableFuture<? extends BatchResult<? extends MessageIdAndMD5>> send(@BinderParam(value=BindSendMessageBatchRequestEntryToIndexedFormParams.class) Iterable<String> var1);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"ReceiveMessage"})
    @XMLResponseParser(value=MessageHandler.class)
    public ListenableFuture<Message> receive();

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"ReceiveMessage"})
    @XMLResponseParser(value=MessageHandler.class)
    public ListenableFuture<? extends Message> receive(ReceiveMessageOptions var1);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"ReceiveMessage"})
    @XMLResponseParser(value=ReceiveMessageResponseHandler.class)
    public ListenableFuture<? extends FluentIterable<? extends Message>> receive(@FormParam(value="MaxNumberOfMessages") int var1);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"ReceiveMessage"})
    @XMLResponseParser(value=ReceiveMessageResponseHandler.class)
    public ListenableFuture<? extends FluentIterable<? extends Message>> receive(@FormParam(value="MaxNumberOfMessages") int var1, ReceiveMessageOptions var2);
}

