/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.binders;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.Json;
import org.jclouds.rest.Binder;
import org.jclouds.softlayer.domain.ProductItemPrice;
import org.jclouds.softlayer.domain.ProductOrder;
import org.jclouds.softlayer.domain.VirtualGuest;

public class ProductOrderToJson
implements Binder {
    private Json json;

    @Inject
    public ProductOrderToJson(Json json) {
        this.json = json;
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkNotNull(input, "order");
        ProductOrder order = (ProductOrder)ProductOrder.class.cast(input);
        request.setPayload(this.buildJson(order));
        return request;
    }

    String buildJson(ProductOrder order) {
        Iterable<Price> prices = Iterables.transform(order.getPrices(), new Function<ProductItemPrice, Price>(){

            @Override
            public Price apply(ProductItemPrice productItemPrice) {
                return new Price(productItemPrice.getId());
            }
        });
        Iterable<HostnameAndDomain> hosts = Iterables.transform(order.getVirtualGuests(), new Function<VirtualGuest, HostnameAndDomain>(){

            @Override
            public HostnameAndDomain apply(VirtualGuest virtualGuest) {
                return new HostnameAndDomain(virtualGuest.getHostname(), virtualGuest.getDomain());
            }
        });
        OrderData data = new OrderData(order.getPackageId(), order.getLocation(), Sets.newLinkedHashSet(prices), Sets.newLinkedHashSet(hosts), order.getQuantity(), order.getUseHourlyPricing());
        return this.json.toJson(ImmutableMap.of("parameters", ImmutableList.of(data)));
    }

    private static class Price {
        private long id;

        public Price(long id) {
            this.id = id;
        }
    }

    private static class HostnameAndDomain {
        private String hostname;
        private String domain;

        public HostnameAndDomain(String hostname, String domain) {
            this.hostname = hostname;
            this.domain = domain;
        }
    }

    private static class OrderData {
        private String complexType = "SoftLayer_Container_Product_Order_Virtual_Guest";
        private long packageId = -1L;
        private String location;
        private Set<Price> prices;
        private Set<HostnameAndDomain> virtualGuests;
        private long quantity;
        private boolean useHourlyPricing;

        public OrderData(long packageId, String location, Set<Price> prices, Set<HostnameAndDomain> virtualGuests, long quantity, boolean useHourlyPricing) {
            this.packageId = packageId;
            this.location = location;
            this.prices = prices;
            this.virtualGuests = virtualGuests;
            this.quantity = quantity;
            this.useHourlyPricing = useHourlyPricing;
        }
    }
}

