/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.xml;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.date.DateService;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.s3.domain.CanonicalUser;
import org.jclouds.s3.domain.ListBucketResponse;
import org.jclouds.s3.domain.ObjectMetadata;
import org.jclouds.s3.domain.ObjectMetadataBuilder;
import org.jclouds.s3.domain.internal.ListBucketResponseImpl;
import org.jclouds.util.SaxUtils;
import org.jclouds.util.Strings2;
import org.xml.sax.Attributes;

public class ListBucketHandler
extends ParseSax.HandlerWithResult<ListBucketResponse> {
    private ImmutableSet.Builder<ObjectMetadata> contents = ImmutableSet.builder();
    private ImmutableSet.Builder<String> commonPrefixes = ImmutableSet.builder();
    private CanonicalUser currentOwner;
    private StringBuilder currentText = new StringBuilder();
    private ObjectMetadataBuilder builder = new ObjectMetadataBuilder();
    private final Provider<UriBuilder> uriBuilders;
    private final DateService dateParser;
    private String bucketName;
    private String prefix;
    private String marker;
    private int maxResults;
    private String delimiter;
    private boolean isTruncated;
    private boolean inCommonPrefixes;
    private String currentKey;
    private String nextMarker;

    @Inject
    public ListBucketHandler(DateService dateParser, Provider<UriBuilder> uriBuilders) {
        this.dateParser = dateParser;
        this.uriBuilders = uriBuilders;
    }

    @Override
    public ListBucketResponse getResult() {
        return new ListBucketResponseImpl(this.bucketName, this.contents.build(), this.prefix, this.marker, this.isTruncated && this.nextMarker == null ? this.currentKey : this.nextMarker, this.maxResults, this.delimiter, this.isTruncated, (Set<String>)((Object)this.commonPrefixes.build()));
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes attrs) {
        if (qName.equals("CommonPrefixes")) {
            this.inCommonPrefixes = true;
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (qName.equals("ID")) {
            this.currentOwner = new CanonicalUser(SaxUtils.currentOrNull(this.currentText));
        } else if (qName.equals("DisplayName")) {
            this.currentOwner.setDisplayName(SaxUtils.currentOrNull(this.currentText));
        } else if (qName.equals("Key")) {
            this.currentKey = SaxUtils.currentOrNull(this.currentText);
            this.builder.key(this.currentKey);
            this.builder.uri(this.uriBuilders.get().uri(this.getRequest().getEndpoint()).path(this.currentKey).replaceQuery("").build(new Object[0]));
        } else if (qName.equals("LastModified")) {
            this.builder.lastModified(this.dateParser.iso8601DateParse(SaxUtils.currentOrNull(this.currentText)));
        } else if (qName.equals("ETag")) {
            String currentETag = SaxUtils.currentOrNull(this.currentText);
            this.builder.eTag(currentETag);
            this.builder.contentMD5(CryptoStreams.hex(Strings2.replaceAll(currentETag, '\"', "")));
        } else if (qName.equals("Size")) {
            this.builder.contentLength(Long.valueOf(SaxUtils.currentOrNull(this.currentText)));
        } else if (qName.equals("Owner")) {
            this.builder.owner(this.currentOwner);
            this.currentOwner = null;
        } else if (qName.equals("StorageClass")) {
            this.builder.storageClass(ObjectMetadata.StorageClass.valueOf(SaxUtils.currentOrNull(this.currentText)));
        } else if (qName.equals("Contents")) {
            this.contents.add((Object)this.builder.build());
            this.builder = new ObjectMetadataBuilder().bucket(this.bucketName);
        } else if (qName.equals("Name")) {
            this.bucketName = SaxUtils.currentOrNull(this.currentText);
            this.builder.bucket(this.bucketName);
        } else if (qName.equals("Prefix")) {
            String prefix = SaxUtils.currentOrNull(this.currentText);
            if (this.inCommonPrefixes) {
                this.commonPrefixes.add((Object)prefix);
            } else {
                this.prefix = prefix;
            }
        } else if (qName.equals("Delimiter")) {
            this.delimiter = SaxUtils.currentOrNull(this.currentText);
        } else if (qName.equals("Marker")) {
            this.marker = SaxUtils.currentOrNull(this.currentText);
        } else if (qName.equals("NextMarker")) {
            this.nextMarker = SaxUtils.currentOrNull(this.currentText);
        } else if (qName.equals("MaxKeys")) {
            this.maxResults = Integer.parseInt(SaxUtils.currentOrNull(this.currentText));
        } else if (qName.equals("IsTruncated")) {
            this.isTruncated = Boolean.parseBoolean(SaxUtils.currentOrNull(this.currentText));
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

