/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rimuhosting.miro.compute.functions;

import com.google.common.base.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.logging.Logger;
import org.jclouds.rimuhosting.miro.domain.Image;

@Singleton
public class RimuHostingImageToImage
implements Function<Image, org.jclouds.compute.domain.Image> {
    @Resource
    @Named(value="jclouds.compute")
    private Logger logger = Logger.NULL;
    public static final Pattern RIMU_PATTERN = Pattern.compile("([a-zA-Z]+) ?([0-9.]+) .*");

    @Override
    public org.jclouds.compute.domain.Image apply(Image from) {
        ImageBuilder builder = new ImageBuilder();
        builder.ids(from.getId() + "");
        builder.name(from.getDescription());
        builder.description(from.getDescription());
        builder.operatingSystem(this.parseOs(from));
        builder.status(Image.Status.AVAILABLE);
        return builder.build();
    }

    protected OperatingSystem parseOs(Image from) {
        OsFamily osFamily = null;
        String osName = from.getId();
        String osArch = null;
        String osVersion = null;
        String osDescription = from.getDescription();
        boolean is64Bit = from.getId().indexOf("64") != -1;
        Matcher matcher = RIMU_PATTERN.matcher(osDescription);
        if (matcher.find()) {
            try {
                osFamily = OsFamily.fromValue(matcher.group(1).toLowerCase());
                osVersion = matcher.group(2).toLowerCase();
            }
            catch (IllegalArgumentException e) {
                this.logger.debug("<< didn't match os(%s)", osDescription);
            }
        }
        return new OperatingSystem(osFamily, osName, osVersion, osArch, osDescription, is64Bit);
    }
}

