/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.binders;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.internal.GeneratedHttpRequest;

@Singleton
public class BindMapToStringPayload
implements MapBinder {
    protected final Provider<UriBuilder> uriBuilders;

    @Inject
    public BindMapToStringPayload(Provider<UriBuilder> uriBuilders) {
        this.uriBuilders = Preconditions.checkNotNull(uriBuilders, "uriBuilders");
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        Preconditions.checkNotNull(postParams, "postParams");
        GeneratedHttpRequest r = (GeneratedHttpRequest)GeneratedHttpRequest.class.cast(Preconditions.checkNotNull(request, "request"));
        Preconditions.checkArgument(r.getJavaMethod().isAnnotationPresent(Payload.class), "method %s must have @Payload annotation to use this binder", r.getJavaMethod());
        String payload = r.getJavaMethod().getAnnotation(Payload.class).value();
        if (postParams.size() > 0) {
            UriBuilder builder = this.uriBuilders.get();
            builder.uri(URI.create("http://fake/"));
            builder.path(payload);
            URI fake = builder.buildFromMap(postParams);
            payload = fake.getPath().substring(1);
        }
        return (R)((HttpRequest.Builder)request.toBuilder().payload(payload)).build();
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object payload) {
        throw new IllegalArgumentException("this is a map binder");
    }
}

