/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.binders;

import com.google.common.base.Preconditions;
import com.google.common.net.InternetDomainName;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindAsHostPrefix
implements Binder {
    private final Provider<UriBuilder> uriBuilderProvider;

    @Inject
    public BindAsHostPrefix(Provider<UriBuilder> uriBuilderProvider) {
        this.uriBuilderProvider = Preconditions.checkNotNull(uriBuilderProvider, "uriBuilderProvider");
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object payload) {
        Preconditions.checkNotNull(payload, "hostprefix");
        Preconditions.checkArgument(InternetDomainName.isValid(request.getEndpoint().getHost()), "this is only valid for hostnames: " + request);
        UriBuilder builder = this.uriBuilderProvider.get().uri(request.getEndpoint());
        InternetDomainName name = InternetDomainName.from(request.getEndpoint().getHost()).child(payload.toString());
        builder.host(name.name());
        return (R)((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder()).endpoint(builder.build(new Object[0]))).build();
    }
}

