/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Types;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.rest.internal.AsyncRestClientProxy;

@Singleton
public class AsyncClientFactory {
    private final Injector injector;

    @Inject
    public AsyncClientFactory(Injector injector) {
        this.injector = injector;
    }

    public <T> T create(Class<T> clazz) {
        return AsyncClientFactory.create(clazz, (AsyncRestClientProxy)this.injector.getInstance(Key.get(TypeLiteral.get(Types.newParameterizedType(AsyncRestClientProxy.class, new Type[]{clazz})))));
    }

    public static <T> T create(Class<T> clazz, AsyncRestClientProxy<T> proxy) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, proxy);
    }
}

