/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.osgi;

import com.google.common.base.Charsets;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.apis.ApiRegistry;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.ProviderRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class MetadataBundleListener
implements BundleListener {
    private Multimap<Long, ProviderMetadata> providerMetadataMap = ArrayListMultimap.create();
    private Multimap<Long, ApiMetadata> apiMetadataMap = ArrayListMultimap.create();

    public void start(BundleContext bundleContext) {
        bundleContext.addBundleListener((BundleListener)this);
        for (Bundle bundle : bundleContext.getBundles()) {
            if (bundle.getState() != 32) continue;
            List<ProviderMetadata> providerMetadataList = this.getProviderMetadata(bundle);
            List<ApiMetadata> apiMetadataList = this.getApiMetadata(bundle);
            for (ProviderMetadata providerMetadata : providerMetadataList) {
                if (providerMetadata == null) continue;
                ProviderRegistry.registerProvider(providerMetadata);
                this.providerMetadataMap.put(bundle.getBundleId(), providerMetadata);
            }
            for (ApiMetadata apiMetadata : apiMetadataList) {
                if (apiMetadata == null) continue;
                ApiRegistry.registerApi(apiMetadata);
                this.apiMetadataMap.put(bundle.getBundleId(), apiMetadata);
            }
        }
    }

    public void stop(BundleContext bundleContext) {
        this.providerMetadataMap.clear();
        this.apiMetadataMap.clear();
    }

    public void bundleChanged(BundleEvent event) {
        Collection<ProviderMetadata> providerMetadataList = null;
        Collection<ApiMetadata> apiMetadataList = null;
        switch (event.getType()) {
            case 2: {
                providerMetadataList = this.getProviderMetadata(event.getBundle());
                apiMetadataList = this.getApiMetadata(event.getBundle());
                for (ProviderMetadata providerMetadata : providerMetadataList) {
                    if (providerMetadata == null) continue;
                    ProviderRegistry.registerProvider(providerMetadata);
                    this.providerMetadataMap.put(event.getBundle().getBundleId(), providerMetadata);
                }
                for (ApiMetadata apiMetadata : apiMetadataList) {
                    if (apiMetadata == null) continue;
                    ApiRegistry.registerApi(apiMetadata);
                    this.apiMetadataMap.put(event.getBundle().getBundleId(), apiMetadata);
                }
                break;
            }
            case 4: 
            case 256: {
                providerMetadataList = this.providerMetadataMap.get(event.getBundle().getBundleId());
                apiMetadataList = this.apiMetadataMap.get(event.getBundle().getBundleId());
                if (providerMetadataList != null) {
                    for (ProviderMetadata providerMetadata : providerMetadataList) {
                        ProviderRegistry.unregisterProvider(providerMetadata);
                    }
                }
                if (apiMetadataList == null) break;
                for (ApiMetadata apiMetadata : apiMetadataList) {
                    ApiRegistry.unRegisterApi(apiMetadata);
                }
                break;
            }
        }
    }

    public List<ProviderMetadata> getProviderMetadata(Bundle bundle) {
        ArrayList<ProviderMetadata> metadataList = Lists.newArrayList();
        String classNames = this.getProviderMetadataClassNames(bundle);
        if (classNames != null && !classNames.isEmpty()) {
            for (String className : classNames.split("\n")) {
                try {
                    Class providerMetadataClass = bundle.loadClass(className);
                    if (!ProviderMetadata.class.isAssignableFrom(providerMetadataClass)) continue;
                    ProviderMetadata metadata = (ProviderMetadata)providerMetadataClass.newInstance();
                    metadataList.add(metadata);
                }
                catch (ClassNotFoundException e) {
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
        }
        return metadataList;
    }

    public List<ApiMetadata> getApiMetadata(Bundle bundle) {
        ArrayList<ApiMetadata> metadataList = Lists.newArrayList();
        String classNames = this.getApiMetadataClassNames(bundle);
        if (classNames != null && !classNames.isEmpty()) {
            for (String className : classNames.split("\n")) {
                try {
                    Class apiMetadataClass = bundle.loadClass(className);
                    if (!ApiMetadata.class.isAssignableFrom(apiMetadataClass)) continue;
                    ApiMetadata metadata = (ApiMetadata)apiMetadataClass.newInstance();
                    metadataList.add(metadata);
                }
                catch (ClassNotFoundException e) {
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
        }
        return metadataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String getMetadataClassNames(Bundle bundle, String pathToMetadata) {
        URL resource = bundle.getEntry(pathToMetadata);
        InputStream is = null;
        InputStreamReader reader = null;
        BufferedReader bufferedReader = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            is = resource.openStream();
            reader = new InputStreamReader(is, Charsets.UTF_8);
            bufferedReader = new BufferedReader(reader);
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        catch (Throwable e) {
            Closeables.closeQuietly(reader);
            Closeables.closeQuietly(bufferedReader);
            Closeables.closeQuietly(is);
            catch (Throwable throwable) {
                Closeables.closeQuietly(reader);
                Closeables.closeQuietly(bufferedReader);
                Closeables.closeQuietly(is);
                throw throwable;
            }
        }
        Closeables.closeQuietly(reader);
        Closeables.closeQuietly(bufferedReader);
        Closeables.closeQuietly(is);
        return sb.toString().trim();
    }

    public String getProviderMetadataClassNames(Bundle bundle) {
        return this.getMetadataClassNames(bundle, "/META-INF/services/org.jclouds.providers.ProviderMetadata");
    }

    public String getApiMetadataClassNames(Bundle bundle) {
        return this.getMetadataClassNames(bundle, "/META-INF/services/org.jclouds.apis.ApiMetadata");
    }
}

