/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.v2_0.functions;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.net.URI;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.internal.ClassMethodArgsAndReturnVal;
import org.jclouds.openstack.v2_0.predicates.ExtensionPredicates;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.functions.ImplicitOptionalConverter;

public class PresentWhenExtensionAnnotationNamespaceEqualsAnyNamespaceInExtensionsSet
implements ImplicitOptionalConverter {
    private final LoadingCache<String, Set<? extends org.jclouds.openstack.v2_0.domain.Extension>> extensions;
    private final Multimap<URI, URI> aliases;

    @Inject
    public PresentWhenExtensionAnnotationNamespaceEqualsAnyNamespaceInExtensionsSet(LoadingCache<String, Set<? extends org.jclouds.openstack.v2_0.domain.Extension>> extensions, Multimap<URI, URI> aliases) {
        this.extensions = Preconditions.checkNotNull(extensions, "extensions");
        this.aliases = aliases == null ? ImmutableMultimap.of() : ImmutableMultimap.copyOf(aliases);
    }

    @Override
    public Optional<Object> apply(ClassMethodArgsAndReturnVal input) {
        Optional<Extension> ext = Optional.fromNullable(input.getClazz().getAnnotation(Extension.class));
        if (ext.isPresent()) {
            URI namespace = URI.create(ext.get().namespace());
            if (input.getArgs() == null || input.getArgs().length == 0) {
                if (Iterables.any((Iterable)this.extensions.getUnchecked(""), ExtensionPredicates.namespaceOrAliasEquals(namespace, this.aliases.get(namespace)))) {
                    return Optional.of(input.getReturnVal());
                }
            } else if (input.getArgs() != null && input.getArgs().length == 1) {
                if (Iterables.any((Iterable)this.extensions.getUnchecked(Preconditions.checkNotNull(input.getArgs()[0], "arg[0] in %s", input).toString()), ExtensionPredicates.namespaceOrAliasEquals(namespace, this.aliases.get(namespace)))) {
                    return Optional.of(input.getReturnVal());
                }
            } else {
                throw new RuntimeException(String.format("expecting zero or one args %s", input));
            }
            return Optional.absent();
        }
        return Optional.of(input.getReturnVal());
    }

    public String toString() {
        return "presentWhenExtensionAnnotationNamespaceEqualsAnyNamespaceInExtensionsSet()";
    }
}

