/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.callables.RunScriptOnNode;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.internal.BaseComputeService;
import org.jclouds.compute.internal.PersistNodeCredentials;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.strategy.CreateNodesInGroupThenAddToSet;
import org.jclouds.compute.strategy.DestroyNodeStrategy;
import org.jclouds.compute.strategy.GetImageStrategy;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.compute.strategy.InitializeRunScriptOnNodeOrPlaceInBadMap;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.compute.strategy.RebootNodeStrategy;
import org.jclouds.compute.strategy.ResumeNodeStrategy;
import org.jclouds.compute.strategy.SuspendNodeStrategy;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.compute.options.NovaTemplateOptions;
import org.jclouds.openstack.nova.v2_0.domain.KeyPair;
import org.jclouds.openstack.nova.v2_0.domain.SecurityGroup;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.SecurityGroupInZone;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ZoneAndName;
import org.jclouds.openstack.nova.v2_0.extensions.KeyPairApi;
import org.jclouds.openstack.nova.v2_0.extensions.SecurityGroupApi;
import org.jclouds.openstack.nova.v2_0.predicates.KeyPairPredicates;
import org.jclouds.openstack.nova.v2_0.predicates.SecurityGroupPredicates;
import org.jclouds.scriptbuilder.functions.InitAdminAccess;

@Singleton
public class NovaComputeService
extends BaseComputeService {
    protected final NovaApi novaApi;
    protected final LoadingCache<ZoneAndName, SecurityGroupInZone> securityGroupMap;
    protected final LoadingCache<ZoneAndName, KeyPair> keyPairCache;
    protected final Function<Set<? extends NodeMetadata>, Multimap<String, String>> orphanedGroupsByZoneId;
    protected final GroupNamingConvention.Factory namingConvention;

    @Inject
    protected NovaComputeService(ComputeServiceContext context, Map<String, Credentials> credentialStore, @Memoized Supplier<Set<? extends Image>> images, @Memoized Supplier<Set<? extends Hardware>> sizes, @Memoized Supplier<Set<? extends Location>> locations, ListNodesStrategy listNodesStrategy, GetImageStrategy getImageStrategy, GetNodeMetadataStrategy getNodeMetadataStrategy, CreateNodesInGroupThenAddToSet runNodesAndAddToSetStrategy, RebootNodeStrategy rebootNodeStrategy, DestroyNodeStrategy destroyNodeStrategy, ResumeNodeStrategy startNodeStrategy, SuspendNodeStrategy stopNodeStrategy, Provider<TemplateBuilder> templateBuilderProvider, @Named(value="DEFAULT") Provider<TemplateOptions> templateOptionsProvider, @Named(value="jclouds.compute.timeout.node-running") Predicate<AtomicReference<NodeMetadata>> nodeRunning, @Named(value="jclouds.compute.timeout.node-terminated") Predicate<AtomicReference<NodeMetadata>> nodeTerminated, @Named(value="jclouds.compute.timeout.node-suspended") Predicate<AtomicReference<NodeMetadata>> nodeSuspended, InitializeRunScriptOnNodeOrPlaceInBadMap.Factory initScriptRunnerFactory, RunScriptOnNode.Factory runScriptOnNodeFactory, InitAdminAccess initAdminAccess, PersistNodeCredentials persistNodeCredentials, ComputeServiceConstants.Timeouts timeouts, @Named(value="jclouds.user-threads") ExecutorService executor, NovaApi novaApi, LoadingCache<ZoneAndName, SecurityGroupInZone> securityGroupMap, LoadingCache<ZoneAndName, KeyPair> keyPairCache, Function<Set<? extends NodeMetadata>, Multimap<String, String>> orphanedGroupsByZoneId, GroupNamingConvention.Factory namingConvention, Optional<ImageExtension> imageExtension) {
        super(context, credentialStore, images, sizes, locations, listNodesStrategy, getImageStrategy, getNodeMetadataStrategy, runNodesAndAddToSetStrategy, rebootNodeStrategy, destroyNodeStrategy, startNodeStrategy, stopNodeStrategy, templateBuilderProvider, templateOptionsProvider, nodeRunning, nodeTerminated, nodeSuspended, initScriptRunnerFactory, initAdminAccess, runScriptOnNodeFactory, persistNodeCredentials, timeouts, executor, imageExtension);
        this.novaApi = Preconditions.checkNotNull(novaApi, "novaApi");
        this.securityGroupMap = Preconditions.checkNotNull(securityGroupMap, "securityGroupMap");
        this.keyPairCache = Preconditions.checkNotNull(keyPairCache, "keyPairCache");
        this.orphanedGroupsByZoneId = Preconditions.checkNotNull(orphanedGroupsByZoneId, "orphanedGroupsByZoneId");
        this.namingConvention = Preconditions.checkNotNull(namingConvention, "namingConvention");
    }

    @Override
    protected void cleanUpIncidentalResourcesOfDeadNodes(Set<? extends NodeMetadata> deadNodes) {
        Multimap<String, String> zoneToZoneAndGroupNames = this.orphanedGroupsByZoneId.apply(deadNodes);
        for (String zoneId : zoneToZoneAndGroupNames.keySet()) {
            this.cleanOrphanedGroupsInZone(ImmutableSet.copyOf(zoneToZoneAndGroupNames.get(zoneId)), zoneId);
        }
    }

    protected void cleanOrphanedGroupsInZone(Set<String> groups, String zoneId) {
        this.cleanupOrphanedSecurityGroupsInZone(groups, zoneId);
        this.cleanupOrphanedKeyPairsInZone(groups, zoneId);
    }

    private void cleanupOrphanedSecurityGroupsInZone(Set<String> groups, String zoneId) {
        Optional<? extends SecurityGroupApi> securityGroupApi = this.novaApi.getSecurityGroupExtensionForZone(zoneId);
        if (securityGroupApi.isPresent()) {
            for (String group : groups) {
                for (SecurityGroup securityGroup : Iterables.filter(securityGroupApi.get().list(), SecurityGroupPredicates.nameMatches(this.namingConvention.create().containsGroup(group)))) {
                    ZoneAndName zoneAndName = ZoneAndName.fromZoneAndName(zoneId, securityGroup.getName());
                    this.logger.debug(">> deleting securityGroup(%s)", zoneAndName);
                    securityGroupApi.get().delete(securityGroup.getId());
                    this.securityGroupMap.invalidate(zoneAndName);
                    this.logger.debug("<< deleted securityGroup(%s)", zoneAndName);
                }
            }
        }
    }

    private void cleanupOrphanedKeyPairsInZone(Set<String> groups, String zoneId) {
        Optional<? extends KeyPairApi> keyPairApi = this.novaApi.getKeyPairExtensionForZone(zoneId);
        if (keyPairApi.isPresent()) {
            for (String group : groups) {
                for (KeyPair pair : keyPairApi.get().list().filter(KeyPairPredicates.nameMatches(this.namingConvention.create().containsGroup(group)))) {
                    ZoneAndName zoneAndName = ZoneAndName.fromZoneAndName(zoneId, pair.getName());
                    this.logger.debug(">> deleting keypair(%s)", zoneAndName);
                    keyPairApi.get().delete(pair.getName());
                    this.keyPairCache.invalidate(zoneAndName);
                    this.logger.debug("<< deleted keypair(%s)", zoneAndName);
                }
                this.keyPairCache.invalidate(ZoneAndName.fromZoneAndName(zoneId, this.namingConvention.create().sharedNameForGroup(group)));
            }
        }
    }

    @Override
    public NovaTemplateOptions templateOptions() {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.templateOptions());
    }
}

