/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.compute.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.config.ComputeServiceAdapterContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.domain.Location;
import org.jclouds.functions.IdentityFunction;
import org.jclouds.openstack.nova.compute.functions.FlavorToHardware;
import org.jclouds.openstack.nova.compute.functions.NovaImageToImage;
import org.jclouds.openstack.nova.compute.functions.NovaImageToOperatingSystem;
import org.jclouds.openstack.nova.compute.functions.ServerToNodeMetadata;
import org.jclouds.openstack.nova.compute.strategy.NovaComputeServiceAdapter;
import org.jclouds.openstack.nova.domain.Flavor;
import org.jclouds.openstack.nova.domain.Image;
import org.jclouds.openstack.nova.domain.ImageStatus;
import org.jclouds.openstack.nova.domain.Server;
import org.jclouds.openstack.nova.domain.ServerStatus;

public class NovaComputeServiceContextModule
extends ComputeServiceAdapterContextModule<Server, Flavor, Image, Location> {
    @VisibleForTesting
    public static final Map<ServerStatus, NodeMetadata.Status> toPortableNodeStatus = ImmutableMap.builder().put(ServerStatus.ACTIVE, NodeMetadata.Status.RUNNING).put(ServerStatus.SUSPENDED, NodeMetadata.Status.SUSPENDED).put(ServerStatus.DELETED, NodeMetadata.Status.TERMINATED).put(ServerStatus.QUEUE_RESIZE, NodeMetadata.Status.PENDING).put(ServerStatus.PREP_RESIZE, NodeMetadata.Status.PENDING).put(ServerStatus.RESIZE, NodeMetadata.Status.PENDING).put(ServerStatus.VERIFY_RESIZE, NodeMetadata.Status.PENDING).put(ServerStatus.RESCUE, NodeMetadata.Status.PENDING).put(ServerStatus.BUILD, NodeMetadata.Status.PENDING).put(ServerStatus.PASSWORD, NodeMetadata.Status.PENDING).put(ServerStatus.REBUILD, NodeMetadata.Status.PENDING).put(ServerStatus.DELETE_IP, NodeMetadata.Status.PENDING).put(ServerStatus.REBOOT, NodeMetadata.Status.PENDING).put(ServerStatus.HARD_REBOOT, NodeMetadata.Status.PENDING).put(ServerStatus.UNKNOWN, NodeMetadata.Status.UNRECOGNIZED).put(ServerStatus.UNRECOGNIZED, NodeMetadata.Status.UNRECOGNIZED).build();
    @VisibleForTesting
    public static final Map<ImageStatus, Image.Status> toPortableImageStatus = ImmutableMap.builder().put(ImageStatus.ACTIVE, Image.Status.AVAILABLE).put(ImageStatus.SAVING, Image.Status.PENDING).put(ImageStatus.PREPARING, Image.Status.PENDING).put(ImageStatus.QUEUED, Image.Status.PENDING).put(ImageStatus.FAILED, Image.Status.ERROR).put(ImageStatus.UNKNOWN, Image.Status.UNRECOGNIZED).put(ImageStatus.UNRECOGNIZED, Image.Status.UNRECOGNIZED).build();

    @Override
    protected void configure() {
        super.configure();
        this.bind(new TypeLiteral<ComputeServiceAdapter<Server, Flavor, Image, Location>>(){}).to(NovaComputeServiceAdapter.class);
        this.bind(new TypeLiteral<Function<Server, NodeMetadata>>(){}).to(ServerToNodeMetadata.class);
        this.bind(new TypeLiteral<Function<Image, org.jclouds.compute.domain.Image>>(){}).to(NovaImageToImage.class);
        this.bind(new TypeLiteral<Function<Image, OperatingSystem>>(){}).to(NovaImageToOperatingSystem.class);
        this.bind(new TypeLiteral<Function<Flavor, Hardware>>(){}).to(FlavorToHardware.class);
        this.bind(new TypeLiteral<Function<Location, Location>>(){}).to((Class)Class.class.cast(IdentityFunction.class));
    }

    @Singleton
    @Provides
    Map<ServerStatus, NodeMetadata.Status> toPortableNodeStatus() {
        return toPortableNodeStatus;
    }

    @Singleton
    @Provides
    Map<ImageStatus, Image.Status> toPortableImageStatus() {
        return toPortableImageStatus;
    }
}

