/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.functions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.domain.AuthenticationResponse;
import org.jclouds.rest.InvocationContext;

public class ParseAuthenticationResponseFromHeaders
implements Function<HttpResponse, AuthenticationResponse>,
InvocationContext<ParseAuthenticationResponseFromHeaders> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final Provider<UriBuilder> uriBuilderProvider;
    private String hostToReplace;

    @Inject
    public ParseAuthenticationResponseFromHeaders(Provider<UriBuilder> uriBuilderProvider) {
        this.uriBuilderProvider = uriBuilderProvider;
    }

    @Override
    public AuthenticationResponse apply(HttpResponse from) {
        HttpUtils.releasePayload(from);
        ImmutableMap.Builder<String, URI> builder = ImmutableMap.builder();
        for (Map.Entry<String, String> entry : from.getHeaders().entries()) {
            if (!entry.getKey().endsWith("-Url")) continue;
            builder.put(entry.getKey(), this.getURI(entry.getValue()));
        }
        AuthenticationResponse response = new AuthenticationResponse(Preconditions.checkNotNull(from.getFirstHeaderOrNull("X-Auth-Token"), "X-Auth-Token"), builder.build());
        this.logger.debug("will connect to: ", response);
        return response;
    }

    protected URI getURI(String headerValue) {
        if (headerValue == null) {
            return null;
        }
        URI toReturn = URI.create(headerValue);
        if (!"127.0.0.1".equals(toReturn.getHost())) {
            return toReturn;
        }
        return this.uriBuilderProvider.get().uri(toReturn).host(this.hostToReplace).build(new Object[0]);
    }

    @Override
    public ParseAuthenticationResponseFromHeaders setContext(HttpRequest request) {
        String host = request.getEndpoint().getHost();
        return this.setHostToReplace(host);
    }

    @VisibleForTesting
    ParseAuthenticationResponseFromHeaders setHostToReplace(String hostToReplace) {
        this.hostToReplace = hostToReplace;
        return this;
    }
}

