/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.nodepool.internal;

import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.inject.Named;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.domain.Location;
import org.jclouds.nodepool.Backend;
import org.jclouds.nodepool.NodePoolComputeServiceAdapter;
import org.jclouds.nodepool.internal.NodeMetadataStore;
import org.jclouds.scriptbuilder.statements.login.AdminAccess;
import org.jclouds.scriptbuilder.statements.login.AdminAccessBuilderSpec;

public abstract class BaseNodePoolComputeServiceAdapter
implements NodePoolComputeServiceAdapter {
    protected final Supplier<ComputeService> backendComputeService;
    protected final Supplier<Template> backendTemplate;
    protected final String poolGroupName;
    protected final NodeMetadataStore metadataStore;
    protected final AdminAccess.Builder initialCredentialsBuilder;

    public BaseNodePoolComputeServiceAdapter(@Backend Supplier<ComputeService> backendComputeService, @Backend Supplier<Template> backendTemplate, @Named(value="jclouds.nodepool.backend-group") String poolGroupName, NodeMetadataStore metadataStore, @Named(value="jclouds.nodepool.admin-access") String poolNodeAdminAccess, AdminAccess.Configuration configuration) {
        this.backendComputeService = backendComputeService;
        this.poolGroupName = poolGroupName;
        this.backendTemplate = backendTemplate;
        this.metadataStore = metadataStore;
        this.initialCredentialsBuilder = AdminAccessBuilderSpec.parse(poolNodeAdminAccess).copyTo(new AdminAccess.Builder());
    }

    @Override
    public NodeMetadata getNode(String id) {
        NodeMetadata backendMetadata = this.backendComputeService.get().getNodeMetadata(id);
        if (backendMetadata == null) {
            return null;
        }
        return this.metadataStore.load(backendMetadata);
    }

    @Override
    public Iterable<NodeMetadata> listNodes() {
        return this.metadataStore.loadAll(this.getBackendNodes());
    }

    @Override
    public Iterable<Hardware> listHardwareProfiles() {
        return ImmutableSet.of(this.backendTemplate.get().getHardware());
    }

    @Override
    public Iterable<Image> listImages() {
        return ImmutableSet.of(this.backendTemplate.get().getImage());
    }

    @Override
    public Iterable<Location> listLocations() {
        return ImmutableSet.of(this.backendTemplate.get().getLocation());
    }

    @Override
    public Image getImage(String id) {
        Image backendImage = this.backendTemplate.get().getImage();
        return backendImage.getId().equals(id) ? backendImage : null;
    }

    @Override
    public void suspendNode(String id) {
        if (this.getNode(id) != null) {
            this.backendComputeService.get().suspendNode(id);
        }
        throw new NoSuchElementException(id);
    }

    @Override
    public void resumeNode(String id) {
        if (this.getNode(id) != null) {
            this.backendComputeService.get().resumeNode(id);
        }
        throw new NoSuchElementException(id);
    }

    @Override
    public void rebootNode(String id) {
        if (this.getNode(id) != null) {
            this.backendComputeService.get().rebootNode(id);
        }
        throw new NoSuchElementException(id);
    }

    protected Set<NodeMetadata> getBackendNodes() {
        return ImmutableSet.copyOf(Iterables.filter(this.backendComputeService.get().listNodesDetailsMatching(NodePredicates.all()), NodePredicates.inGroup(this.poolGroupName)));
    }

    @Override
    public void destroyPool() {
        this.metadataStore.deleteAllMappings();
        this.backendComputeService.get().destroyNodesMatching(NodePredicates.inGroup(this.poolGroupName));
    }

    @Override
    public ComputeServiceContext getBackendComputeServiceContext() {
        return this.backendComputeService.get().getContext();
    }

    protected Set<? extends NodeMetadata> addToPool(int number) {
        try {
            Template template = this.backendTemplate.get().clone();
            template.getOptions().runScript(this.initialCredentialsBuilder.build());
            return this.backendComputeService.get().createNodesInGroup(this.poolGroupName, number, template);
        }
        catch (RunNodesException e) {
            throw Throwables.propagate(e);
        }
    }

    @Override
    public String getPoolGroupName() {
        return this.poolGroupName;
    }
}

