/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.nodepool.config;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Module;
import com.google.inject.PrivateModule;
import com.google.inject.Provides;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.nodepool.Backend;

public class BindJcloudsModules
extends PrivateModule {
    @Override
    protected void configure() {
    }

    @Provides
    @Singleton
    @Backend
    protected Set<Module> provideBackendModules(@Named(value="jclouds.nodepool.backend-modules") String moduleString) {
        return ImmutableSet.copyOf(Iterables.transform(Splitter.on(',').split(moduleString), new Function<String, Module>(){

            @Override
            public Module apply(String input) {
                try {
                    return (Module)Module.class.cast(Class.forName(input).newInstance());
                }
                catch (InstantiationException e) {
                    throw Throwables.propagate(e);
                }
                catch (IllegalAccessException e) {
                    throw Throwables.propagate(e);
                }
                catch (ClassNotFoundException e) {
                    throw Throwables.propagate(e);
                }
            }
        }));
    }
}

