/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.nodepool;

import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.Context;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.Utils;
import org.jclouds.compute.internal.ComputeServiceContextImpl;
import org.jclouds.location.Provider;
import org.jclouds.nodepool.NodePoolComputeServiceAdapter;
import org.jclouds.nodepool.NodePoolStats;

@Singleton
public class NodePoolComputeServiceContext
extends ComputeServiceContextImpl {
    private final NodePoolComputeServiceAdapter adapter;

    @Inject
    public NodePoolComputeServiceContext(@Provider Context backend, @Provider TypeToken<? extends Context> backendType, ComputeService computeService, Utils utils, NodePoolComputeServiceAdapter adapter) {
        super(backend, backendType, computeService, utils);
        this.adapter = adapter;
    }

    public NodePoolStats getPoolStats() {
        return new NodePoolStats(this.adapter.currentSize(), this.adapter.idleNodes(), this.adapter.usedNodes(), this.adapter.maxNodes(), this.adapter.minNodes());
    }

    public void destroyPool() {
        this.adapter.destroyPool();
    }

    public ComputeServiceContext getBackendContext() {
        return this.adapter.getBackendComputeServiceContext();
    }

    public String getPoolGroupName() {
        return this.adapter.getPoolGroupName();
    }
}

