/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.logging.internal;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.FileBackedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Resource;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.PayloadEnclosing;
import org.jclouds.io.Payloads;
import org.jclouds.logging.Logger;

public abstract class Wire {
    @Resource
    protected Logger logger = Logger.NULL;

    protected abstract Logger getWireLog();

    private void wire(String header, InputStream instream) {
        StringBuilder buffer = new StringBuilder();
        try {
            int ch;
            while ((ch = instream.read()) != -1) {
                if (ch == 13) {
                    buffer.append("[\\r]");
                    continue;
                }
                if (ch == 10) {
                    buffer.append("[\\n]\"");
                    buffer.insert(0, "\"");
                    buffer.insert(0, header);
                    this.getWireLog().debug(buffer.toString(), new Object[0]);
                    buffer.setLength(0);
                    continue;
                }
                if (ch < 32 || ch > 127) {
                    buffer.append("[0x");
                    buffer.append(Integer.toHexString(ch));
                    buffer.append("]");
                    continue;
                }
                buffer.append((char)ch);
            }
            if (buffer.length() > 0) {
                buffer.append('\"');
                buffer.insert(0, '\"');
                buffer.insert(0, header);
                this.getWireLog().debug(buffer.toString(), new Object[0]);
            }
        }
        catch (IOException e) {
            this.logger.error(e, "Error tapping line", new Object[0]);
        }
    }

    public boolean enabled() {
        return this.getWireLog().isDebugEnabled();
    }

    public InputStream copy(String header, InputStream instream) {
        InputStream inputStream;
        int limit = 262144;
        FileBackedOutputStream out = null;
        try {
            out = new FileBackedOutputStream(limit);
            long bytesRead = ByteStreams.copy(instream, (OutputStream)out);
            if (bytesRead >= (long)limit) {
                this.logger.debug("over limit %d/%d: wrote temp file", bytesRead, limit);
            }
            this.wire(header, out.getSupplier().getInput());
            inputStream = out.getSupplier().getInput();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Error tapping line", e);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(out);
                Closeables.closeQuietly(instream);
                throw throwable;
            }
        }
        Closeables.closeQuietly(out);
        Closeables.closeQuietly(instream);
        return inputStream;
    }

    public InputStream input(InputStream instream) {
        return this.copy("<< ", Preconditions.checkNotNull(instream, "input"));
    }

    public void input(PayloadEnclosing request) {
        Payload oldContent = request.getPayload();
        Payload wiredPayload = Payloads.newPayload(this.input(oldContent.getInput()));
        this.copyPayloadMetadata(oldContent, wiredPayload);
        request.setPayload(wiredPayload);
    }

    public void output(PayloadEnclosing request) {
        Payload wiredPayload;
        Payload oldContent = request.getPayload();
        try {
            wiredPayload = Payloads.newPayload(this.output(oldContent.getRawContent()));
        }
        catch (UnsupportedOperationException e) {
            wiredPayload = Payloads.newPayload(this.output(oldContent.getInput()));
        }
        this.copyPayloadMetadata(oldContent, wiredPayload);
        request.setPayload(wiredPayload);
    }

    private void copyPayloadMetadata(Payload oldContent, Payload wiredPayload) {
        MutableContentMetadata oldMd = oldContent.getContentMetadata();
        MutableContentMetadata wiredMd = wiredPayload.getContentMetadata();
        if (oldMd.getContentLength() != null) {
            wiredMd.setContentLength(oldMd.getContentLength());
        }
        wiredMd.setContentType(oldMd.getContentType());
        wiredMd.setContentMD5(oldMd.getContentMD5());
        wiredMd.setContentDisposition(oldMd.getContentDisposition());
        wiredMd.setContentEncoding(oldMd.getContentEncoding());
        wiredMd.setContentLanguage(oldMd.getContentLanguage());
        wiredMd.setExpires(oldMd.getExpires());
    }

    public <T> T output(T data) {
        Preconditions.checkNotNull(data, "data");
        if (data instanceof InputStream) {
            return (T)this.copy(">> ", (InputStream)data);
        }
        if (data instanceof byte[]) {
            this.output((byte[])data);
            return data;
        }
        if (data instanceof String) {
            this.output((String)data);
            return data;
        }
        if (data instanceof File) {
            this.output((File)data);
            return data;
        }
        throw new UnsupportedOperationException("Content not supported " + data.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void output(File out) {
        Preconditions.checkNotNull(out, "output");
        FileInputStream in = null;
        try {
            in = new FileInputStream(out);
            this.wire(">> ", in);
        }
        catch (FileNotFoundException e) {
            try {
                this.logger.error(e, "Error tapping file: %s", out);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(in);
                throw throwable;
            }
            Closeables.closeQuietly(in);
        }
        Closeables.closeQuietly(in);
    }

    private void output(byte[] b) {
        this.wire(">> ", new ByteArrayInputStream(Preconditions.checkNotNull(b, "output")));
    }

    private void output(String s) {
        this.output(Preconditions.checkNotNull(s, "output").getBytes());
    }
}

