/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.utils;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.util.Strings2;

public class Queries {
    public static Multimap<String, String> parseQueryToMap(String in) {
        LinkedListMultimap<String, String> map = LinkedListMultimap.create();
        if (in != null) {
            if (in.indexOf(38) == -1) {
                if (in.contains("=")) {
                    Queries.parseKeyValueFromStringToMap(in, map);
                } else {
                    map.put(in, null);
                }
            } else {
                String[] parts;
                for (String part : parts = in.split("&")) {
                    Queries.parseKeyValueFromStringToMap(part, map);
                }
            }
        }
        return map;
    }

    public static void parseKeyValueFromStringToMap(String stringToParse, Multimap<String, String> map) {
        int indexOfFirstEquals = stringToParse.indexOf(61);
        String key = indexOfFirstEquals == -1 ? stringToParse : stringToParse.substring(0, indexOfFirstEquals);
        String value = indexOfFirstEquals == -1 ? null : stringToParse.substring(indexOfFirstEquals + 1);
        map.put(Strings2.urlDecode(key), Strings2.urlDecode(value));
    }

    public static String makeQueryLine(Multimap<String, String> params, @Nullable Comparator<Map.Entry<String, String>> sorter, char ... skips) {
        Iterator<Map.Entry<String, String>> pairs = (sorter == null ? params.entries() : ImmutableSortedSet.copyOf(sorter, params.entries())).iterator();
        StringBuilder formBuilder = new StringBuilder();
        while (pairs.hasNext()) {
            Map.Entry<String, String> pair = pairs.next();
            formBuilder.append(Strings2.urlEncode(pair.getKey(), skips));
            if (pair.getValue() != null) {
                formBuilder.append("=");
            }
            if (pair.getValue() != null && !pair.getValue().equals("")) {
                formBuilder.append(Strings2.urlEncode(pair.getValue(), skips));
            }
            if (!pairs.hasNext()) continue;
            formBuilder.append("&");
        }
        return formBuilder.toString();
    }
}

