/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.functions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.elasticstack.domain.ServerInfo;
import org.jclouds.elasticstack.functions.ListOfKeyValuesDelimitedByBlankLinesToServerInfoSet;
import org.jclouds.http.HttpResponse;

@Singleton
public class KeyValuesDelimitedByBlankLinesToServerInfo
implements Function<HttpResponse, ServerInfo> {
    private final ListOfKeyValuesDelimitedByBlankLinesToServerInfoSet setParser;

    @Inject
    public KeyValuesDelimitedByBlankLinesToServerInfo(ListOfKeyValuesDelimitedByBlankLinesToServerInfoSet setParser) {
        this.setParser = setParser;
    }

    @Override
    public ServerInfo apply(HttpResponse response) {
        Set<ServerInfo> drives = this.setParser.apply(response);
        if (drives.size() == 0) {
            return null;
        }
        return Iterables.get(drives, 0);
    }
}

