/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import com.google.common.base.Supplier;
import java.util.Date;
import javax.inject.Inject;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.date.DateCodec;
import org.jclouds.date.DateCodecFactory;
import org.jclouds.ec2.domain.Snapshot;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.location.Region;

public class SnapshotHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Snapshot> {
    private StringBuilder currentText = new StringBuilder();
    protected final DateCodec dateCodec;
    protected final Supplier<String> defaultRegion;
    private String id;
    private String volumeId;
    private int volumeSize;
    private Snapshot.Status status;
    private Date startTime;
    private int progress;
    private String ownerId;
    private String description;
    private String ownerAlias;

    @Inject
    public SnapshotHandler(DateCodecFactory dateCodecFactory, @Region Supplier<String> defaultRegion) {
        this.dateCodec = dateCodecFactory.iso8601();
        this.defaultRegion = defaultRegion;
    }

    @Override
    public Snapshot getResult() {
        String region = AWSUtils.findRegionInArgsOrNull(this.getRequest());
        if (region == null) {
            region = this.defaultRegion.get();
        }
        Snapshot snapshot = new Snapshot(region, this.id, this.volumeId, this.volumeSize, this.status, this.startTime, this.progress, this.ownerId, this.description, this.ownerAlias);
        this.id = null;
        this.volumeId = null;
        this.volumeSize = 0;
        this.status = null;
        this.startTime = null;
        this.progress = 0;
        this.ownerId = null;
        this.description = null;
        this.ownerAlias = null;
        return snapshot;
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (qName.equals("snapshotId")) {
            this.id = this.currentText.toString().trim();
        } else if (qName.equals("volumeId")) {
            this.volumeId = this.currentText.toString().trim();
        } else if (qName.equals("volumeSize")) {
            this.volumeSize = Integer.parseInt(this.currentText.toString().trim());
        } else if (qName.equals("status")) {
            this.status = Snapshot.Status.fromValue(this.currentText.toString().trim());
        } else if (qName.equals("startTime")) {
            this.startTime = this.dateCodec.toDate(this.currentText.toString().trim());
        } else if (qName.equals("progress")) {
            String progressString = this.currentText.toString().trim();
            if (!progressString.equals("")) {
                progressString = progressString.substring(0, progressString.length() - 1);
                this.progress = Integer.parseInt(progressString);
            }
        } else if (qName.equals("ownerId")) {
            this.ownerId = this.currentText.toString().trim();
        } else if (qName.equals("description")) {
            this.description = this.currentText.toString().trim();
        } else if (qName.equals("ownerAlias")) {
            this.ownerAlias = this.currentText.toString().trim();
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

