/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.ec2.compute.EC2ComputeService;
import org.jclouds.ec2.compute.domain.PasswordDataAndPrivateKey;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.extensions.EC2ImageExtension;
import org.jclouds.ec2.compute.functions.AddElasticIpsToNodemetadata;
import org.jclouds.ec2.compute.functions.CreateUniqueKeyPair;
import org.jclouds.ec2.compute.functions.CredentialsForInstance;
import org.jclouds.ec2.compute.functions.EC2ImageParser;
import org.jclouds.ec2.compute.functions.PasswordCredentialsFromWindowsInstance;
import org.jclouds.ec2.compute.functions.RunningInstanceToNodeMetadata;
import org.jclouds.ec2.compute.functions.WindowsLoginCredentialsFromEncryptedData;
import org.jclouds.ec2.compute.internal.EC2TemplateBuilderImpl;
import org.jclouds.ec2.compute.loaders.CreateSecurityGroupIfNeeded;
import org.jclouds.ec2.compute.loaders.LoadPublicIpForInstanceOrNull;
import org.jclouds.ec2.compute.loaders.RegionAndIdToImage;
import org.jclouds.ec2.compute.options.EC2TemplateOptions;
import org.jclouds.ec2.compute.predicates.GetImageWhenStatusAvailablePredicateWithResult;
import org.jclouds.ec2.compute.predicates.SecurityGroupPresent;
import org.jclouds.ec2.domain.Image;
import org.jclouds.ec2.domain.InstanceState;
import org.jclouds.ec2.domain.KeyPair;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.predicates.PredicateWithResult;
import org.jclouds.predicates.RetryablePredicate;

public class EC2ComputeServiceDependenciesModule
extends AbstractModule {
    public static final Map<InstanceState, NodeMetadata.Status> toPortableNodeStatus = ImmutableMap.builder().put(InstanceState.PENDING, NodeMetadata.Status.PENDING).put(InstanceState.RUNNING, NodeMetadata.Status.RUNNING).put(InstanceState.SHUTTING_DOWN, NodeMetadata.Status.PENDING).put(InstanceState.TERMINATED, NodeMetadata.Status.TERMINATED).put(InstanceState.STOPPING, NodeMetadata.Status.PENDING).put(InstanceState.STOPPED, NodeMetadata.Status.SUSPENDED).put(InstanceState.UNRECOGNIZED, NodeMetadata.Status.UNRECOGNIZED).build();
    @VisibleForTesting
    public static final Map<Image.ImageState, Image.Status> toPortableImageStatus = ImmutableMap.builder().put(Image.ImageState.AVAILABLE, Image.Status.AVAILABLE).put(Image.ImageState.DEREGISTERED, Image.Status.DELETED).put(Image.ImageState.UNRECOGNIZED, Image.Status.UNRECOGNIZED).build();

    @Singleton
    @Provides
    protected Map<InstanceState, NodeMetadata.Status> toPortableNodeStatus() {
        return toPortableNodeStatus;
    }

    @Singleton
    @Provides
    protected Map<Image.ImageState, Image.Status> toPortableImageStatus() {
        return toPortableImageStatus;
    }

    @Override
    protected void configure() {
        this.bind(TemplateBuilder.class).to(EC2TemplateBuilderImpl.class);
        this.bind(TemplateOptions.class).to(EC2TemplateOptions.class);
        this.bind(ComputeService.class).to(EC2ComputeService.class);
        this.bind(new TypeLiteral<CacheLoader<RunningInstance, LoginCredentials>>(){}).to(CredentialsForInstance.class);
        this.bind(new TypeLiteral<Function<RegionAndName, KeyPair>>(){}).to(CreateUniqueKeyPair.class);
        this.bind(new TypeLiteral<CacheLoader<RegionAndName, org.jclouds.compute.domain.Image>>(){}).to(RegionAndIdToImage.class);
        this.bind(new TypeLiteral<CacheLoader<RegionAndName, String>>(){}).annotatedWith(Names.named("SECURITY")).to(CreateSecurityGroupIfNeeded.class);
        this.bind(new TypeLiteral<CacheLoader<RegionAndName, String>>(){}).annotatedWith(Names.named("ELASTICIP")).to(LoadPublicIpForInstanceOrNull.class);
        this.bind(new TypeLiteral<Function<PasswordDataAndPrivateKey, LoginCredentials>>(){}).to(WindowsLoginCredentialsFromEncryptedData.class);
        this.bind(new TypeLiteral<Function<RunningInstance, LoginCredentials>>(){}).to(PasswordCredentialsFromWindowsInstance.class);
        this.bind(new TypeLiteral<Function<Image, org.jclouds.compute.domain.Image>>(){}).to(EC2ImageParser.class);
        this.bind(new TypeLiteral<ImageExtension>(){}).to(EC2ImageExtension.class);
        this.bind(new TypeLiteral<PredicateWithResult<String, org.jclouds.compute.domain.Image>>(){}).to(GetImageWhenStatusAvailablePredicateWithResult.class);
    }

    @Provides
    @Singleton
    public Function<RunningInstance, NodeMetadata> bindNodeConverter(RunningInstanceToNodeMetadata baseConverter, AddElasticIpsToNodemetadata addElasticIpsToNodemetadata, @Named(value="jclouds.ec2.auto-allocate-elastic-ips") boolean autoAllocateElasticIps) {
        if (!autoAllocateElasticIps) {
            return baseConverter;
        }
        return Functions.compose(addElasticIpsToNodemetadata, baseConverter);
    }

    @Provides
    @Singleton
    protected LoadingCache<RunningInstance, LoginCredentials> credentialsMap(CacheLoader<RunningInstance, LoginCredentials> in) {
        return CacheBuilder.newBuilder().build(in);
    }

    @Provides
    @Singleton
    protected ConcurrentMap<RegionAndName, KeyPair> keypairMap(Injector i) {
        return Maps.newConcurrentMap();
    }

    @Provides
    @Singleton
    @Named(value="SECURITY")
    protected LoadingCache<RegionAndName, String> securityGroupMap(@Named(value="SECURITY") CacheLoader<RegionAndName, String> in) {
        return CacheBuilder.newBuilder().build(in);
    }

    @Provides
    @Singleton
    @Named(value="ELASTICIP")
    protected LoadingCache<RegionAndName, String> instanceToElasticIp(@Named(value="ELASTICIP") CacheLoader<RegionAndName, String> in) {
        return CacheBuilder.newBuilder().build(in);
    }

    @Provides
    @Singleton
    @Named(value="SECURITY")
    protected Predicate<RegionAndName> securityGroupEventualConsistencyDelay(SecurityGroupPresent in, @Named(value="jclouds.ec2.timeout.securitygroup-present") long msDelay) {
        return new RetryablePredicate<RegionAndName>(in, msDelay, 100L, TimeUnit.MILLISECONDS);
    }
}

