/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.xml;

import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.deltacloud.domain.HardwareProfile;
import org.jclouds.deltacloud.domain.HardwareProperty;
import org.jclouds.deltacloud.xml.HardwarePropertyHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HardwareProfileHandler
extends ParseSax.HandlerWithResult<HardwareProfile> {
    private StringBuilder currentText = new StringBuilder();
    private final HardwarePropertyHandler propertyHandler;
    private URI href;
    private String id;
    private String name;
    private Set<HardwareProperty> properties = Sets.newLinkedHashSet();
    private boolean inProperty;
    private HardwareProfile profile;

    @Inject
    HardwareProfileHandler(HardwarePropertyHandler propertyHandler) {
        this.propertyHandler = propertyHandler;
    }

    @Override
    public HardwareProfile getResult() {
        return this.profile;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        Map<String, String> attributes = SaxUtils.cleanseAttributes(attrs);
        if (qName.equals("property")) {
            this.inProperty = true;
        }
        if (this.inProperty) {
            this.propertyHandler.startElement(uri, localName, qName, attrs);
        } else if (qName.equals("hardware_profile")) {
            String href = attributes.get("href");
            if (href != null) {
                this.href = URI.create(href);
            }
            this.id = attributes.get("id");
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.inProperty) {
            this.propertyHandler.endElement(uri, localName, qName);
        }
        if (qName.endsWith("property")) {
            this.inProperty = false;
            this.properties.add(this.propertyHandler.getResult());
        } else if (qName.equalsIgnoreCase("name")) {
            this.name = this.currentText.toString().trim();
        } else if (qName.equalsIgnoreCase("hardware_profile")) {
            this.profile = new HardwareProfile(this.href, this.id, this.name, this.properties);
            this.href = null;
            this.id = null;
            this.name = null;
            this.properties = Sets.newLinkedHashSet();
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

