/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jclouds.concurrent.DynamicThreadPoolExecutor;

public class DynamicExecutors {
    public static ExecutorService newScalingThreadPool(int min, int max, long keepAliveTime) {
        return DynamicExecutors.newScalingThreadPool(min, max, keepAliveTime, Executors.defaultThreadFactory());
    }

    public static ExecutorService newScalingThreadPool(int min, int max, long keepAliveTime, ThreadFactory threadFactory) {
        DynamicThreadPoolExecutor.DynamicQueue<Runnable> queue = new DynamicThreadPoolExecutor.DynamicQueue<Runnable>();
        DynamicThreadPoolExecutor executor = new DynamicThreadPoolExecutor(min, max, keepAliveTime, TimeUnit.MILLISECONDS, queue, threadFactory);
        executor.setRejectedExecutionHandler(new DynamicThreadPoolExecutor.ForceQueuePolicy());
        queue.setThreadPoolExecutor(executor);
        return executor;
    }

    public static ExecutorService newBlockingThreadPool(int min, int max, long keepAliveTime, int capacity, long waitTime) {
        return DynamicExecutors.newBlockingThreadPool(min, max, keepAliveTime, capacity, waitTime, Executors.defaultThreadFactory());
    }

    public static ExecutorService newBlockingThreadPool(int min, int max, long keepAliveTime, int capacity, long waitTime, ThreadFactory threadFactory) {
        DynamicThreadPoolExecutor.DynamicQueue<Runnable> queue = new DynamicThreadPoolExecutor.DynamicQueue<Runnable>(capacity);
        DynamicThreadPoolExecutor executor = new DynamicThreadPoolExecutor(min, max, keepAliveTime, TimeUnit.MILLISECONDS, queue, threadFactory);
        executor.setRejectedExecutionHandler(new DynamicThreadPoolExecutor.TimedBlockingPolicy(waitTime));
        queue.setThreadPoolExecutor(executor);
        return executor;
    }

    public static ThreadFactory daemonThreadFactory(String namePrefix) {
        final ThreadFactory f = Executors.defaultThreadFactory();
        final String o = namePrefix + "-";
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = f.newThread(r);
                t.setName(o + t.getName());
                t.setDaemon(true);
                return t;
            }
        };
    }

    public static ThreadFactory priorityThreadFactory(int priority, String namePrefix) {
        final ThreadFactory f = DynamicExecutors.daemonThreadFactory(namePrefix);
        final int p = priority;
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = f.newThread(r);
                if (p != 5) {
                    t.setPriority(p);
                }
                return t;
            }
        };
    }

    private DynamicExecutors() {
    }
}

