/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.Location;

public class TemplateImpl
implements Template {
    private final Image image;
    private final Hardware hardware;
    private final Location location;
    private final TemplateOptions options;

    public TemplateImpl(Image image, Hardware hardware, Location location, TemplateOptions options) {
        this.image = Preconditions.checkNotNull(image, "image");
        this.hardware = Preconditions.checkNotNull(hardware, "hardware");
        this.location = Preconditions.checkNotNull(location, "location");
        this.options = Preconditions.checkNotNull(options, "options");
    }

    @Override
    public Image getImage() {
        return this.image;
    }

    @Override
    public Hardware getHardware() {
        return this.hardware;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public TemplateOptions getOptions() {
        return this.options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateImpl that = (TemplateImpl)TemplateImpl.class.cast(o);
        return Objects.equal(this.image, that.image) && Objects.equal(this.hardware, that.hardware) && Objects.equal(this.location, that.location) && Objects.equal(this.options, that.options);
    }

    public int hashCode() {
        return Objects.hashCode(this.image, this.hardware, this.location, this.options);
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        Objects.ToStringHelper helper = Objects.toStringHelper("").omitNullValues().add("image", this.image).add("hardware", this.hardware).add("location", this.location);
        if (!this.options.equals(this.defaultOptions())) {
            helper.add("options", this.options);
        }
        return helper;
    }

    protected TemplateOptions defaultOptions() {
        return TemplateOptions.NONE;
    }

    @Override
    public Template clone() {
        return new TemplateImpl(this.image, this.hardware, this.location, this.options.clone());
    }
}

