/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.callables;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.eventbus.EventBus;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import org.jclouds.compute.callables.InitScriptConfigurationForTasks;
import org.jclouds.compute.callables.RunScriptOnNode;
import org.jclouds.compute.callables.SudoAwareInitManager;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.events.InitScriptOnNodeSubmission;
import org.jclouds.compute.events.StatementOnNodeCompletion;
import org.jclouds.compute.events.StatementOnNodeFailure;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.scriptbuilder.InitScript;
import org.jclouds.scriptbuilder.domain.AdminAccessVisitor;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.scriptbuilder.statements.login.AdminAccess;
import org.jclouds.ssh.SshClient;
import org.jclouds.ssh.SshException;

public class RunScriptOnNodeAsInitScriptUsingSsh
extends SudoAwareInitManager
implements RunScriptOnNode {
    protected final EventBus eventBus;

    @AssistedInject
    public RunScriptOnNodeAsInitScriptUsingSsh(Function<NodeMetadata, SshClient> sshFactory, EventBus eventBus, InitScriptConfigurationForTasks initScriptConfiguration, @Assisted NodeMetadata node, @Assisted Statement script, @Assisted RunScriptOptions options) {
        super(sshFactory, options.shouldRunAsRoot(), Preconditions.checkNotNull(node, "node"), initScriptConfiguration, Preconditions.checkNotNull(script, "script") instanceof InitScript ? (InitScript)InitScript.class.cast(script) : RunScriptOnNodeAsInitScriptUsingSsh.createInitScript(Preconditions.checkNotNull(initScriptConfiguration, "initScriptConfiguration"), options.getTaskName(), script));
        this.eventBus = Preconditions.checkNotNull(eventBus, "eventBus");
    }

    @Override
    public RunScriptOnNodeAsInitScriptUsingSsh init() {
        super.init();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecResponse call() {
        Preconditions.checkState(this.ssh != null, "please call init() before invoking call");
        try {
            this.ssh.connect();
            ExecResponse returnVal = this.doCall();
            this.eventBus.post(new StatementOnNodeCompletion(this.init, this.node, returnVal));
            ExecResponse execResponse = returnVal;
            return execResponse;
        }
        finally {
            if (this.ssh != null) {
                this.ssh.disconnect();
            }
        }
    }

    public static InitScript createInitScript(InitScriptConfigurationForTasks config, String name, Statement script) {
        if (name == null) {
            name = "jclouds-script-" + config.getAnonymousTaskSuffixSupplier().get();
        }
        return InitScript.builder().name(name).home(config.getBasedir() + "/" + name).run(script).build();
    }

    protected void refreshSshIfNewAdminCredentialsConfigured(AdminAccess input) {
        if (input.getAdminCredentials() != null && input.shouldGrantSudoToAdminUser()) {
            this.ssh.disconnect();
            this.logger.debug(">> reconnecting as %s@%s", input.getAdminCredentials().identity, this.ssh.getHostAddress());
            this.node = NodeMetadataBuilder.fromNodeMetadata(this.node).credentials(LoginCredentials.fromCredentials(input.getAdminCredentials())).build();
            this.ssh = (SshClient)this.sshFactory.apply(this.node);
            this.ssh.connect();
            this.setupLinkToInitFile();
        }
    }

    protected ExecResponse doCall() {
        this.eventBus.post(new InitScriptOnNodeSubmission(this.init, this.node));
        try {
            try {
                this.ssh.put(this.initFile, this.init.render(OsFamily.UNIX));
            }
            catch (SshException e) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.warn(e, "<< (%s) problem using sftp [%s], attempting via sshexec", this.ssh.toString(), e.getMessage());
                } else {
                    this.logger.warn("<< (%s) problem using sftp [%s], attempting via sshexec", this.ssh.toString(), e.getMessage());
                }
                this.ssh.disconnect();
                this.ssh.connect();
                this.ssh.exec("rm " + this.initFile);
                this.ssh.exec(Statements.appendFile(this.initFile, Splitter.on('\n').split(this.init.render(OsFamily.UNIX)), "END_OF_JCLOUDS_FILE_" + this.init.getInstanceName()).render(OsFamily.UNIX));
            }
            this.ssh.exec("chmod 755 " + this.initFile);
            this.setupLinkToInitFile();
            this.runAction("init");
            this.init.getInitStatement().accept(new AdminAccessVisitor(){

                @Override
                public void visit(AdminAccess input) {
                    RunScriptOnNodeAsInitScriptUsingSsh.this.refreshSshIfNewAdminCredentialsConfigured(input);
                }
            });
            return this.runAction("start");
        }
        catch (Throwable e) {
            this.eventBus.post(new StatementOnNodeFailure(this.init, this.node, e));
            throw Throwables.propagate(e);
        }
    }

    protected void setupLinkToInitFile() {
        this.ssh.exec(String.format("ln -fs %s %s", this.initFile, this.init.getInstanceName()));
    }
}

