/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;

public class EncryptedPasswordAndPrivateKey {
    private final String encryptedPassword;
    private final String privateKey;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromEncryptedPasswordAndPrivateKey(this);
    }

    @ConstructorProperties(value={"encryptedPassword", "privateKey"})
    protected EncryptedPasswordAndPrivateKey(@Nullable String encryptedPassword, @Nullable String privateKey) {
        this.encryptedPassword = encryptedPassword;
        this.privateKey = privateKey;
    }

    @Nullable
    public String getEncryptedPassword() {
        return this.encryptedPassword;
    }

    @Nullable
    public String getPrivateKey() {
        return this.privateKey;
    }

    public int hashCode() {
        return Objects.hashCode(this.encryptedPassword, this.privateKey);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EncryptedPasswordAndPrivateKey that = (EncryptedPasswordAndPrivateKey)EncryptedPasswordAndPrivateKey.class.cast(obj);
        return Objects.equal(this.encryptedPassword, that.encryptedPassword) && Objects.equal(this.privateKey, that.privateKey);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).add("encryptedPassword", this.encryptedPassword).add("privateKey", this.privateKey);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String encryptedPassword;
        protected String privateKey;

        protected abstract T self();

        public T encryptedPassword(String encryptedPassword) {
            this.encryptedPassword = encryptedPassword;
            return this.self();
        }

        public T privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this.self();
        }

        public EncryptedPasswordAndPrivateKey build() {
            return new EncryptedPasswordAndPrivateKey(this.encryptedPassword, this.privateKey);
        }

        public T fromEncryptedPasswordAndPrivateKey(EncryptedPasswordAndPrivateKey in) {
            return ((Builder)this.encryptedPassword(in.getEncryptedPassword())).privateKey(in.getPrivateKey());
        }
    }
}

